
function [WII,WIER,WIEL,WERI,WELI,xE,xI] = gcn1learn

close all

T_long = 14400;     %total sim time (s)
T = 10;             %sim time blocks (s)
dt = 1/2000;       %step size of numerical integration (s)

N = struct('E',200,'I',80);   % numbers of cells

w0 = 0.001;
WII = w0*(2*rand(N.I)-1);      % initialize weights
WERI = w0*(2*rand(N.E,N.I)-1);
WELI = w0*(2*rand(N.E,N.I)-1);
WIER = w0*(2*rand(N.I,N.E)-1);
WIEL = w0*(2*rand(N.I,N.E)-1);

eta = 0.015;   % learning rate

TER = -100*ones(N.E,1);    % most recent spike time
TEL = -100*ones(N.E,1); 
TI = -100*ones(N.I,1); 

xE = (1:N.E)'/N.E;  %  m      
xI = (1:N.I)'/N.I;  %  m

AE = ones(size(xE));
ind = find(abs(xE-.50)>.28);
AE(ind) = exp(-60*((abs(xE(ind)-.50)-.28)/.72).^2);

AI = ones(size(xI));
ind = find(abs(xI-.50)>.28);
AI(ind) = exp(-60*((abs(xI(ind)-.50)-.28)/.72).^2);

FER = zeros(N.E,1);
FEL = zeros(N.E,1);
FI = zeros(N.I,1);

thrER = exprnd(ones(N.E,1));
thrEL = exprnd(ones(N.E,1));
thrI = exprnd(ones(N.I,1));

%STDP parameters
l=0.1;          %length of STDP kernel (s)
tau_STDP = 0.006;   %STDP time constant

%Sinusoidal animal trajectory for training
x = (sin((dt:dt:T)*2*pi/(T/2)-pi)+1)/2;
v = diff(x)/dt; v = [v(1),v];
s2 = 0.02^2;

for tt = 1:T_long/T %OUTER time loop (T_long sec)
    
    for t = 2:T/dt %INNER time loop (T sec)
        
        realt = T*(tt-1) + t*dt;
        tmp = 10*AE.*exp(-(x(t)-xE).^2/s2);
        FERn = max(1+0.9*v(t),0)*tmp;
        FELn = max(1-0.9*v(t),0)*tmp;
        FIn = 50*AI.*exp(-(x(t)-xI).^2/s2);
        FER = FER + dt*FERn;              % cumm spike rates
        FEL = FEL + dt*FELn;     
        FI = FI + dt*FIn;
        
        spER = find(FER > thrER);    % spiking ER cells
        
        if sum(spER)>0    % process ER spikes
            
            TER(spER) = realt;    % record time
            FER(spER) = 0;    % reset cumm spike rate
            nERs = length(spER);
            thrER(spER) = exprnd(ones(nERs,1));   % reset thresholds
            
            for n = 1:nERs,
                
                k = spER(n);     % cell k has spiked
                Deltat = TI - realt;
                dWP = 2*eta*exp(Deltat/(2*tau_STDP));
                WERI(k,:) = max(WERI(k,:) - dWP',0);  % potentiate presyn weights
                dWD = eta*exp(Deltat/(3*tau_STDP));
                WIER(:,k) = max(WIER(:,k) - dWD,0);  % depress postsyn weights
                
            end
            
        end
        
        spEL = find(FEL > thrEL);
        
        if sum(spEL)>0    % adjust weights of spiking EL cells
            
            TEL(spEL) = realt;
            FEL(spEL) = 0;
            nELs = length(spEL);
            thrEL(spEL) = exprnd(ones(nELs,1));
            
            for n = 1:nELs,
                
                k = spEL(n);     % cell k has spiked
                Deltat = TI - realt;
                dWP = 2*eta*exp(Deltat/(2*tau_STDP));
                WELI(k,:) = max(WELI(k,:) - dWP',0);  % potentiate presyn weights
                dWD = eta*exp(Deltat/(3*tau_STDP));
                WIEL(:,k) = max(WIEL(:,k) - dWD,0);  % depress postsyn weights
                
            end
            
        end
        
        spI = find(FI > thrI);   % adjust weights of spiking I cells
        
        if sum(spI)>0
            
            TI(spI) = realt;
            FI(spI) = 0;
            nIs = length(spI);
            thrI(spI) = exprnd(ones(nIs,1));
            
            for n = 1:nIs,
                
                k = spI(n);     % cell k has spiked
                
                Deltat = TER - realt;
                dWP = 1.2*eta*exp(Deltat/(4*tau_STDP));
                WIER(k,:) = WIER(k,:) + dWP';  % potentiate presyn weights
                dWD = eta*exp(Deltat/(4*tau_STDP));
                WERI(:,k) = WERI(:,k) + dWD;  % depress postsyn weights
                
                Deltat = TEL - realt;
                dWP = 1.2*eta*exp(Deltat/(4*tau_STDP));
                WIEL(k,:) = WIEL(k,:) + dWP';  % potentiate presyn weights
                dWD = eta*exp(Deltat/(4*tau_STDP));
                WELI(:,k) = WELI(:,k) + dWD;  % depress postsyn weights
                
                Deltat = TI - realt;
                dWP = 3.5*eta*exp(Deltat/(4*tau_STDP));
                WII(k,:) = WII(k,:) + dWP';  % potentiate presyn weights
                dWD = 7*eta*exp(Deltat/(2*tau_STDP));
                WII(:,k) = max(WII(:,k) - dWD,0);  % depress postsyn weights
                
            end
            
        end
        
    end  % t
    
    disp(['elapsed time: ', num2str(realt),' sec'])
    
    if mod(tt,6) == 0
    figure(1)
    plot(WIEL(:,N.E/2),'k','linewidth',1.5)
    hold on
    plot(WIER(:,N.E/2),'r','linewidth',1.5)
    hold off
    xlim([20 60])
    legend('W_{IE_L}','W_{IE_R}')
    xlabel('neuron','fontsize',14)
    ylabel('synaptic weight','fontsize',14)
    
    figure(2)
    plot(-WELI(:,N.I/2),'k','linewidth',1.5)
    hold on
    plot(-WERI(:,N.I/2),'r','linewidth',1.5)
    hold off
    xlim([50 150])
    legend('W_{E_L I}','W_{E_R I}')
    xlabel('neuron','fontsize',14)
    ylabel('synaptic weight','fontsize',14)
    
    figure(3)
    plot(-WII(:,N.I/2),'k','linewidth',1.5)
    xlim([20 60])
    legend('W_{II}')
    xlabel('neuron','fontsize',14)
    ylabel('synaptic weight','fontsize',14)
    
    drawnow 
    end
    
end % tt

return

Displaying gcn1learn.m.