function analyze_data(corr_with,plot_what)

% load summary statistics
SIGMA = csvread('EstimationVariability.csv');
MU = csvread('EstimationBias.csv');
y = csvread('Detection.csv');
RT = csvread('EstimationRT.csv');
n_det = csvread('NostimDetected.csv');

Traits = csvread('Traits.csv');
AQ = Traits(:,3); RISC = Traits(:,4); 
SPQ = Traits(:,5); SPQ(isnan(SPQ))=[]; WEMWBS = Traits(:,6);     
angles = [-64 -48 -32 -16 0 16 32 48 64];

if nargin<2
    plot_what = 'relevant';
end
    
if strcmp(corr_with,'AQ')
    Xx=AQ; xleib = 'AQ'; tail='both'; xl=[0 50];
elseif strcmp(corr_with,'RISC')
    Xx=RISC; xleib = 'RISC'; tail = 'both'; xl=[0 60];
elseif strcmp(corr_with,'WEMWBS')
    Xx=WEMWBS; xleib = 'WEMWBS'; tail = 'both'; xl=[20 80];
elseif strcmp(corr_with,'SPQ')
    Xx=SPQ; xleib = 'SPQ'; tail = 'both'; xl=[0 65];
    RT(40:end,:)=[]; MU(40:end,:)=[];
    y(40:end,:)=[]; SIGMA(40:end,:)=[]; n_det(40:end,:)=[];    
elseif strcmp(corr_with,'AQAD')
    Xx=AQAttentionToDetail; xleib = 'AQ: Attention to Detail'; tail = 'both'; xl=[0 10];
    RT(40:end,:)=[]; MU(40:end,:)=[];
    y(40:end,:)=[]; SIGMA(40:end,:)=[]; n_det(40:end,:)=[];
elseif strcmp(corr_with,'AQI')
    Xx=AQImagination; xleib = 'AQ: Imagination'; tail = 'both'; xl=[0 10];
    RT(40:end,:)=[]; MU(40:end,:)=[]; 
    y(40:end,:)=[]; SIGMA(40:end,:)=[]; n_det(40:end,:)=[];
elseif strcmp(corr_with,'AQAS')
    Xx=AQAttentionSwitching; xleib = 'AQ: Attention Switching'; tail = 'both'; xl=[0 10];
    RT(40:end,:)=[]; MU(40:end,:)=[];
    y(40:end,:)=[]; SIGMA(40:end,:)=[]; n_det(40:end,:)=[];
elseif strcmp(corr_with,'AQSS')
    Xx=AQSocialSkill; xleib = 'AQ: Social Skill'; tail = 'both'; xl=[0 10];
    RT(40:end,:)=[]; MU(40:end,:)=[];
    y(40:end,:)=[]; SIGMA(40:end,:)=[]; n_det(40:end,:)=[];
elseif strcmp(corr_with,'AQC')
    Xx=AQCommunication; xleib = 'AQ: Communication'; tail = 'both'; xl=[0 10];
    RT(40:end,:)=[]; MU(40:end,:)=[];
    y(40:end,:)=[]; SIGMA(40:end,:)=[]; n_det(40:end,:)=[];
end

mRT = mean(RT,2); mdet = mean(y,2); mstd = mean(SIGMA,2); 
mbias = mean(abs(MU),2); tot_hal = sum(n_det,2);

if strcmp(plot_what,'all')
    values = [mRT mRT_std mdet mstd mbias, tot_hal]; sb = 7;
    ylabels = {'Mean RT (s)', 'Mean std of RT (s)', 'Mean detection', 'Mean variability (deg)', ...
        'Mean absolute bias (deg)', 'Total number of hallucinations'};
elseif strcmp(plot_what,'relevant') 
    values = [mbias mstd tot_hal]; sb = 3;
    ylabels = {'Mean absolute bias (deg)', 'Mean variability (deg)' ...
        'Number of ''hallucinations'''};
end


%% Parameter Histograms
% figure('WindowStyle', 'docked');
% subplot(1,3,1); histogram(AQ,15); grid on;
% ylabel('Counts', 'Fontsize', 14); xlabel('AQ', 'Fontsize', 16);
% subplot(1,3,2); histogram(RISC,13); grid on;
% ylabel('Counts', 'Fontsize', 14); xlabel('RISC', 'Fontsize', 16);
% subplot(1,3,3); histogram(SPQ,9); grid on;
% ylabel('Counts', 'Fontsize', 14); xlabel('SPQ', 'Fontsize', 16);


%% Main plots
figure('WindowStyle', 'docked')
for i = 1:sb
    subplot(1,sb,i); hold on  
    [~,CI] = corr_boot(Xx,values(:,i),10000, [xleib, ylabels(i)],'out_keep','fig_no');
    [rho,p] = corr(Xx,values(:,i),'Type','Spearman','tail', tail);
    scatter(Xx,values(:,i),400,'k.'); lsline; grid on; %xlim([0 60])
    xlabel(xleib, 'Fontsize', 13); ylabel(ylabels(i), 'Fontsize', 13)
    title(sprintf('\\rho = %.3f, p = %.3f \nCI(95%%) = [%.3f %.3f]', rho, p, CI(1), CI(2)))
    set(gca, 'box', 'on', 'linewidth', 1); xlim(xl)
end     
       
end 