function [MU, SIGMA, B] = estimation(new_opt, root, ind_plot, split)
% estimation bias and standard deviation
%
%INPUT:
%options structure with fields -  fold:        ('on'/'off')
%                              -  contrast:    (1, 2, 'both', 'combine')
%                              -  session:     (1, 2, 'both')                
%                              -  stats:       ('on'/'off')                
%                              -  scatterplot: ('on'/'off')  
%                              -  lineplot:    ('on'/'off')  
%                              -  write_new:   ('on'/'off') %
%FIGURES
%figure 1: bias vs angle
%figure 2: std vs angle
%figure 3: bias scatterplot 1
%figure 4: bias scatterplot 2
%
%STATS
% bias ANOVA
% standard deviation ANOVA

% set path and option structure
addpath(genpath('..'));
% close all
opt = struct(...
    'fold', 'on',...
    'contrast', 'combine',...
    'session',  'both',...
    'stats', 'off',...
    'scatterplot', 'on',...
    'lineplot', 'on',...
    'write_new', 'off'...
    );

names = fieldnames(opt);
for i = 1:numel(names)
    try
        eval(sprintf('opt.%s = new_opt.%s;', names{i}, names{i}));
    end            
end

try 
    SIGMA = csvread('EstimationVariability.csv');
    MU = csvread('EstimationBias.csv');
catch
    
    %% collect data
    DATA = collect_data(root); 
    angles = [-64 -48 -32  -16  0  16  32 48 64];
    
    if strcmp(opt.contrast, 'combine')
        for i = 1:size(DATA, 1)
            DATA{i}(round(DATA{i}(:, 2))==3, 2)=2; opt.contrast = 1;        
        end
    elseif strcmp(opt.contrast, '1')
        opt.contrast = 1;  
    elseif strcmp(opt.contrast, '2')
        opt.contrast = 2;  
    end

    angles_init = [-64 -48 -32  -16  0  16  32 48 64];
    angles = angles_init;
    sigma=0; mu = 0; background = 0;


    %% collect matrix z of 'fraction detected data'
    [mu, sigma, background] = data_est_circ(DATA,2); %save('./data/parametric_data', 'mu', 'sigma', 'background');

    %% average data across different contrasts
    if strcmp(opt.contrast, 'both')
        MU = squeeze(mean(mu, 3));
        SIGMA = squeeze(mean(sigma, 3));
        B = squeeze(mean(background, 3));
    else
        MU = squeeze(mu(:, :, opt.contrast));
        SIGMA = squeeze(sigma(:, :, opt.contrast));
        B = squeeze(background(:, :, opt.contrast));
    end
    % save('./data/est_data_83_combc2', 'MU', 'SIGMA', 'B');

end

angles = [-64 -48 -32  -16  0  16  32 48 64];
 
%% if fold, collapse data across central angle
if strcmp(opt.fold, 'on')
    angles = [0 16 32 48 64];
    MU = [MU(:, 5) (MU(:, 6:9)-MU(:, 4:-1:1))/2];
    SIGMA = [SIGMA(:, 5) (SIGMA(:, 6:9)+SIGMA(:, 4:-1:1))/2];
end
    
if strcmp(split, 'on')
    %% general population data
    Traits = csvread('Traits.csv');
    AQ = Traits(:,3);
    
    spl = median(AQ); % median split
    hMU = MU(AQ>spl,:); hSIGMA = SIGMA(AQ>spl,:);
    lMU = MU(AQ<spl,:); lSIGMA = SIGMA(AQ<spl,:);
    leg1 = 'High AQ'; leg2 = 'Low AQ';
end


%% plot bias and standard deviation as a function of angle
if strcmp(opt.lineplot, 'on')
   
%% Bias as a function of angles  
    figure(3); hold on; grid on;
    
    if strcmp(split, 'on')
        withinsubject_errorbar(angles, MU, 'k')
        withinsubject_errorbar(angles, hMU, 'b')           %higher half
        withinsubject_errorbar(angles, lMU, 'r')           %lower half
    else
        withinsubject_errorbar(angles, MU, 'k')

        if strcmp(ind_plot, 'on')
            plot(angles, MU', 'o-', 'LineWidth', 1);      %ind perf
        end
    end
        
    if strcmp(opt.fold, 'on')
        set(gca, 'Xlim', [-5 70], 'Fontsize', 16); %, 'Ylim', [-18 10], 'Fontsize', 16)
    else
        set(gca, 'Xlim', [-70 70], 'Fontsize', 16) % [58 73], 'Fontsize', 16)
    end
    
    vline(32, 'k--'); vline(-32, 'k--')
    xlabel('Motion direction (deg)', 'Fontsize', 20)
    ylabel('Bias (deg)', 'Fontsize', 20)
    set(gca, 'box', 'on', 'linewidth', 1)   
    
    if strcmp(split, 'on')
        legend('All',leg1, leg2)
    end
    
%% Std as a function of angles  
    figure(4); hold on; grid on;
    
    if strcmp(split, 'on')
        withinsubject_errorbar(angles, SIGMA, 'k')
        withinsubject_errorbar(angles, hSIGMA, 'b')           %higher half
        withinsubject_errorbar(angles, lSIGMA, 'r')           %lower half
    else
        withinsubject_errorbar(angles, SIGMA, 'k')

        if strcmp(ind_plot, 'on')
            plot(angles, SIGMA', 'o-', 'LineWidth', 1);      %ind perf
        end
    end
        
    if strcmp(opt.fold, 'on')
        set(gca, 'Xlim', [-5 70], 'Fontsize', 16); %, 'Ylim', [-18 10], 'Fontsize', 16)
    else
        set(gca, 'Xlim', [-70 70], 'Fontsize', 16) % [58 73], 'Fontsize', 16)
    end
    
    vline(32, 'k--'); vline(-32, 'k--')
    xlabel('Motion direction (deg)', 'Fontsize', 20)
    ylabel('Standard deviation (deg)', 'Fontsize', 20)
    set(gca, 'box', 'on', 'linewidth', 1)   
    
    if strcmp(split, 'on')
        legend('All',leg1, leg2)
    end
        
end

end
