
%% Computes spearman's correlation and bootsraps confidence intervals

function [rho,CI,p] = corr_boot(x,y,nboot,VarNames,outliers,figs)

alpha=0.05; % significance threshold

if nargin<4
   VarNames = {'x', 'y'};
   outliers = 'out_keep';
   figs = 'fig_yes';
elseif nargin<5
   outliers = 'out_keep';
   figs = 'fig_yes';
elseif nargin<6
   figs = 'fig_yes';
end

VarNames = string(VarNames);

ox=[]; xr =x; yr=y;
% detect outliers (2std)
if strcmp(outliers,'out_rem')
    indx1 = find(y>median(y)+3*median(abs(y-median(y))) | y<median(y)-3*median(abs(y-median(y))));
    oy = y(indx1); ox = x(indx1);
    y(indx1)=[]; x(indx1)=[];    
%     indx2 = find(x>mean(x)+2*std(x) | x<mean(x)-2*std(x));
%     oy = [oy' y(indx2)']'; ox = [ox' x(indx2)']';
%     y(indx2)=[]; x(indx2)=[];   
end

bootstat = bootstrp(nboot,@(x1,y2)corr(x1,y2,'type','Spearman'),x,y);
CI = prctile(bootstat,[100*alpha/2,100*(1-alpha/2)]);
[rho,rhop] = corr(x,y,'type','Pearson');
p = 2*(1+sum((bootstat-rho)>=sign(rho)*rho))/(nboot+1);

if strcmp(figs,'fig_yes')
    figure;
    subplot(1,2,1); hold on; grid on
    scatter(x,y,200,'k.');lsline; %ciplot([1:max(x)].*CI(1),[1:max(x)].*CI(2));
    if ~isempty(ox); scatter(ox,oy,200,'r.'); end
    title(sprintf('\\rho = %.3f, p = %.3f',rho,rhop));
    xlabel(VarNames{1}); ylabel(VarNames{2}, 'Fontsize', 14);
    axis([0 max(xr)+max(xr)/5 0 max(yr)+max(yr)/5]);
    
%     subplot(1,3,2); hold on; grid on
%     [a, rx] = sort(x); [a, ry] = sort(y);
%     rankx(rx) =1:numel(rx); ranky(ry) =1:numel(ry); 
%     scatter(rankx,ranky,300,'k.')
%     xlabel('rank(x)'); ylabel('rank(y)')
%     
%     % compute and plot regression line with CI on ranked data
%     fitresult = fit(rankx',ranky','poly1'); ci = confint(fitresult,0.95);
%     X = [linspace(0,length(xr)+5,length(xr))];
%     CIf = predint(fitresult,X,0.95,'functional','on');
% 
%     %if ~isempty(ox), scatter(ox,oy,300,'r.'), end % needs to be converted
%     %to rank
%     plot_ci(X,[fitresult(X) CIf(:,1) CIf(:,2)], 'PatchColor', 'b', 'PatchAlpha', 0.2, ...
%       'MainLineWidth', 2, 'MainLineStyle', '-', 'MainLineColor', 'b', ...
%       'LineWidth', 0.1, 'LineStyle','--', 'LineColor', 'k');
%     title(sprintf('\\rho = %.3f \np=%.3f \nCI(95%%) = [%.3f %.3f]',fitresult.p1,rhop,ci(1),ci(2)));

    subplot(1,2,2)
    hist(bootstat); vline([CI(1) CI(2)],'r');
    title(sprintf('Bootstrap; p = %.3f\nCI (95%%) = [%.3f %.3f]',p,CI(1),CI(2)));
    xlabel('Spearman \rho'); ylabel('counts', 'Fontsize', 14);
end

