%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% INPUT:
% 
% model - 'Bayes' / 'Bayesbi' / 'Bayesbis' / 'Bayes2*'
% est_file - parameter estimation file (includes estimation configuration)
% corr_with - 'AQ' / 'RISC' / 'WB' / 'SPQ'
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function analyze_params(model, est_file, corr_with)

% load summary statistics
SIGMA = csvread('EstimationVariability.csv');
MU = csvread('EstimationBias.csv');
y = csvread('Detection.csv');
RT = csvread('EstimationRT.csv');
n_det = csvread('NostimDetected.csv');

Traits = csvread('Traits.csv');
AQ = Traits(:,3); RISC = Traits(:,4); 
SPQ = Traits(:,5); SPQ(isnan(SPQ))=[]; WEMWBS = Traits(:,6);   
angles = [-64 -48 -32 -16 0 16 32 48 64];

try
    Y = csvread('BayesEstimatedParams.csv');
    sigma_m = [];
catch
    load(est_file)
end

if strcmp(corr_with,'AQ')
    Xx = AQ; xleib = 'AQ'; xl=[0 50];
elseif strcmp(corr_with,'RISC')
    Xx = RISC; xleib = 'RISC'; xl=[0 60];
elseif strcmp(corr_with,'WEMWBS')
    Xx = WEMWBS; xleib = 'WEMWBS'; xl=[20 80];
elseif strcmp(corr_with,'SPQ')
    Xx = SPQ; xleib = 'SPQ'; xl=[0 65];
    RT(40:end,:)=[]; MU(40:end,:)=[]; y(40:end,:)=[]; SIGMA(40:end,:)=[]; 
    Y(40:end,:)=[]; RISC(40:end,:)=[]; AQ(40:end,:)=[]; WEMWBS(40:end,:)=[]; sigma_m(40:end,:)=[];
elseif strcmp(corr_with,'AQAD')
    Xx=AQAttentionToDetail; xleib = 'AQ: Attention to Detail'; tail = 'both'; xl=[0 10];
    RT(40:end,:)=[]; MU(40:end,:)=[]; B(40:end,:)=[]; y(40:end,:)=[]; SIGMA(40:end,:)=[]; hall_tw(40:end,:)=[];
    Y(40:end,:)=[]; RISC(40:end,:)=[]; AQ(40:end,:)=[]; WB(40:end,:)=[]; sigma_m(40:end,:)=[];
elseif strcmp(corr_with,'AQI')
    Xx=AQImagination; xleib = 'AQ: Imagination'; tail = 'both'; xl=[0 10];
    RT(40:end,:)=[]; MU(40:end,:)=[]; B(40:end,:)=[]; y(40:end,:)=[]; SIGMA(40:end,:)=[]; hall_tw(40:end,:)=[];
    Y(40:end,:)=[]; RISC(40:end,:)=[]; AQ(40:end,:)=[]; WB(40:end,:)=[]; sigma_m(40:end,:)=[];
elseif strcmp(corr_with,'AQAS')
    Xx=AQAttentionSwitching; xleib = 'AQ: Attention Switching'; tail = 'both'; xl=[0 10];
    RT(40:end,:)=[]; MU(40:end,:)=[]; B(40:end,:)=[]; y(40:end,:)=[]; SIGMA(40:end,:)=[]; hall_tw(40:end,:)=[];
    Y(40:end,:)=[]; RISC(40:end,:)=[]; AQ(40:end,:)=[]; WB(40:end,:)=[]; sigma_m(40:end,:)=[];
elseif strcmp(corr_with,'AQSS')
    Xx=AQSocialSkill; xleib = 'AQ: Social Skill'; tail = 'both'; xl=[0 10];
    RT(40:end,:)=[]; MU(40:end,:)=[]; B(40:end,:)=[]; y(40:end,:)=[]; SIGMA(40:end,:)=[]; hall_tw(40:end,:)=[];
    Y(40:end,:)=[]; RISC(40:end,:)=[]; AQ(40:end,:)=[]; WB(40:end,:)=[]; sigma_m(40:end,:)=[];
elseif strcmp(corr_with,'AQC')
    Xx=AQCommunication; xleib = 'AQ: Communication'; tail = 'both'; xl=[0 10];
    RT(40:end,:)=[]; MU(40:end,:)=[]; B(40:end,:)=[]; y(40:end,:)=[]; SIGMA(40:end,:)=[]; hall_tw(40:end,:)=[];
    Y(40:end,:)=[]; RISC(40:end,:)=[]; AQ(40:end,:)=[]; WB(40:end,:)=[]; sigma_m(40:end,:)=[];
end

%relevant behavioral data
bias = mean(abs(MU),2); stdd = mean(SIGMA,2);
beh = [bias stdd]; behlab = {'Mean absolute bias' 'Variability'};

if strcmp(model,'Bayes')
    theta_p = Y(:,1); sigm_p = Y(:,2);
    sigm_l = Y(:,3); sigm_lp = sigm_l./sigm_p;
    rand_est = Y(:,4); 
    
    ylabels = {'\theta_{exp}', '\sigma_{exp}', '\sigma_{sens}', '\sigma_{sens}/\sigma_{exp}' '\alpha', '\sigma_{motor}'};
    values = [theta_p sigm_p sigm_l sigm_lp rand_est sigma_m];
    
    ylabels2 = {'\theta_{exp}', '\sigma_{exp}', '\sigma_{sens}', '\alpha'};
    values2 = [theta_p sigm_p sigm_l rand_est];

%     ylabels = {'\theta_{exp}', '\sigma_{exp}', '\sigma_{sens}', '\alpha'};
%     values = [theta_p sigm_p sigm_l rand_est];
%     
elseif strcmp(model,'Bayesbis')
    theta_p = Y(:,1); theta_n = Y(:,2);
    sigm_p = Y(:,3); sigm_l = Y(:,4); sigm_lp = sigm_l./sigm_p;
    rand_est = Y(:,5); bimod = Y(:,6); bimod = abs(2*abs(bimod-0.5)-1);
    
    ylabels = {'\theta_p', '\theta_n', '\sigma_p', '\sigma_l', '\sigma_l/\sigma_p' '\alpha', 'bimod', '\sigma_m'};
    values = [theta_p theta_n sigm_p sigm_l sigm_lp rand_est bimod sigma_m];    
    
    ylabels2 = {'\sigma_p', '\sigma_l', '\sigma_l/\sigma_p', 'bimod', '\sigma_m'};
    values2 = [sigm_p sigm_l sigm_lp bimod sigma_m];  

elseif strcmp(model, 'Bayesbi')    
    theta_p = Y(:,1); theta_n = Y(:,2); sigm_p = Y(:,3); sigm_n = Y(:,4);
    sigm_l = Y(:,5); rand_est = Y(:,6); 
    sigm_np = (sigm_n+sigm_p)/2; sigm_lp = sigm_l./sigm_np;

    ylabels = {'\theta_p', '\theta_n', '\sigma_p', '\sigma_n', '(\sigma_n+\sigma_p)/2', '\sigma_l', '\sigma_l/\sigma_{np}', '\alpha', '\sigma_m'};
    values = [theta_p theta_n sigm_p sigm_n sigm_np sigm_lp sigm_l rand_est sigma_m];
    
    ylabels2 = {'\sigma_p', '\sigma_n', '(\sigma_n+\sigma_p)/2', '\sigma_l', '\sigma_l/\sigma_{np}', '\sigma_m'};
    values2 = [sigm_p sigm_n sigm_np sigm_lp sigm_l sigma_m];

elseif strcmp(model, 'Bayes2bis') || strcmp(model, 'Bayes3bis')    
    theta_p = Y(:,1); theta_n = Y(:,2); sigm_p = Y(:,3); sigm_l = Y(:,4); 
    sigm_lp = sigm_l./sigm_p; rand_est = Y(:,5); 
    bimod = Y(:,6); bimod = abs(2*abs(bimod-0.5)-1);
    b = Y(:,7); d = Y(:,8); c = Y(:,9);
    
    vars = who('-regexp', 'loglike_bayes'); evalc(['loglikelihood =',vars{1}]); %assign likelihood of the fit to 'likelihood'
    
    ylabels = {'\theta_p', '\theta_n', '\sigma_p', '\sigma_l', '\sigma_l/\sigma_p' '\alpha', 'bimod', 'b', 'd', 'c', '\sigma_m', 'loglike'};
    values = [theta_p theta_n sigm_p sigm_l sigm_lp rand_est bimod b d c sigma_m loglikelihood];    
    
    ylabels2 = {'\sigma_p', '\sigma_l', '\sigma_l/\sigma_p', 'b', 'd', 'c', '\sigma_m'};
    values2 = [sigm_p sigm_l sigm_lp b d c sigma_m];   

elseif strcmp(model, 'Bayes2') || strcmp(model, 'Bayes3')    
    theta_p = Y(:,1); sigm_p = Y(:,2);
    b = Y(:,3); sigm_l = Y(:,4); sigm_lp = sigm_l./sigm_p;
    c = Y(:,5); d = Y(:,6); rand_est = Y(:,7); 
    
    vars = who('-regexp', 'loglike_bayes'); evalc(['loglikelihood =',vars{1}]); %assign likelihood of the fit to 'likelihood'

    ylabels = {'\theta_p', '\sigma_p', '\sigma_l', '\sigma_l/\sigma_p' '\alpha', 'b', 'd', 'c', '\sigma_m', 'loglike'};
    if size(loglikelihood,1)==1, loglikelihood=loglikelihood'; end
    values = [theta_p sigm_p sigm_l sigm_lp rand_est b d c sigma_m loglikelihood];
    
    ylabels2 = {'\sigma_p', '\sigma_l', '\sigma_l/\sigma_p', 'b', 'd', 'c', '\sigma_m'};
    values2 = [sigm_p sigm_l sigm_lp b d c sigma_m];       
elseif strcmp(model, 'Bayespower')
    theta_p = Y(:,1); sigm_p = Y(:,2);
    sigm_l = Y(:,3); sigm_lp = sigm_l./sigm_p;
    rand_est = Y(:,4); pow = Y(:,5);
    
    ylabels = {'\theta_p', '\sigma_p', '\sigma_l', '\sigma_l/\sigma_p' '\alpha', 'power'};
    values = [theta_p sigm_p sigm_l sigm_lp rand_est pow];
    
    ylabels2 = {'\sigma_p', '\sigma_l', '\sigma_l/\sigma_p', 'power'};
    values2 = [sigm_p sigm_l sigm_lp pow];
elseif strcmp(model, 'Bayesfpm')
    sigm_p = Y(:,1); sigm_l = Y(:,2); sigm_lp = sigm_l./sigm_p;
    rand_est = Y(:,3); bimod = Y(:,4);
    
    ylabels = {'\sigma_p', '\sigma_l', '\sigma_l/\sigma_p' '\alpha', 'bimod'};
    values = [sigm_p sigm_l sigm_lp rand_est bimod];
    
    ylabels2 = {'\sigma_p', '\sigma_l', '\sigma_l/\sigma_p', 'bimod'};
    values2 = [sigm_p sigm_l sigm_lp bimod];
elseif strcmp(model, 'Bayes2bis') || strcmp(model, 'Bayes3bis')    
    theta_p = Y(:,1); theta_n = Y(:,2); sigm_p = Y(:,3); sigm_l = Y(:,4); 
    sigm_lp = sigm_l./sigm_p; rand_est = Y(:,5); 
    bimod = Y(:,6); bimod = abs(2*abs(bimod-0.5)-1);
    b = Y(:,7); d = Y(:,8); c = Y(:,9); pow = Y(:,10);
    
    vars = who('-regexp', 'loglike_bayes'); evalc(['loglikelihood =',vars{1}]); %assign likelihood of the fit to 'likelihood'
    
    ylabels = {'\theta_p', '\theta_n', '\sigma_p', '\sigma_l', '\sigma_l/\sigma_p','bimod', 'b', 'd', 'c', '\sigma_m', '\kappa' 'loglike'};
    values = [theta_p theta_n sigm_p sigm_l sigm_lp rand_est bimod b d c sigma_m pow loglikelihood];    
    
    ylabels2 = {'\sigma_p', '\sigma_l', '\sigma_l/\sigma_p', 'b', 'd', 'c', '\sigma_m', '\kappa'};
    values2 = [sigm_p sigm_l sigm_lp b d c sigma_m pow];  
elseif strcmp(model,'Bayesbist')
    theta_p = Y(:,1); sigm_p = Y(:,2); sigm_l = Y(:,3); sigm_lp = sigm_l./sigm_p;
    rand_est = Y(:,4); bimod = Y(:,5); bimod = abs(2*abs(bimod-0.5)-1);
    
    ylabels = {'\theta_p', '\sigma_p', '\sigma_l', '\sigma_l/\sigma_p' '\alpha', 'bimod', '\sigma_m'};
    values = [theta_p sigm_p sigm_l sigm_lp rand_est bimod sigma_m];    
    
    ylabels2 = {'\sigma_p', '\sigma_l', '\sigma_l/\sigma_p', 'bimod', '\sigma_m'};
    values2 = [sigm_p sigm_l sigm_lp bimod sigma_m];  
elseif strcmp(model, 'Bayes3bisp') 
    theta_p = Y(:,1); theta_n = Y(:,2); sigm_p = Y(:,3); sigm_l = Y(:,4); 
    sigm_lp = sigm_l./sigm_p; rand_est = Y(:,5); 
    bimod = Y(:,6); bimod = abs(2*abs(bimod-0.5)-1);
    b = Y(:,7); d = Y(:,8); c = Y(:,9); pow=Y(:,10);
    
    vars = who('-regexp', 'loglike_bayes'); evalc(['loglikelihood =',vars{1}]); %assign likelihood of the fit to 'likelihood'
    
    ylabels = {'\theta_p', '\theta_n', '\sigma_p', '\sigma_l', '\sigma_l/\sigma_p' '\alpha', 'bimod', 'b', 'd', 'c', '\kappa', 'loglike'};
    values = [theta_p theta_n sigm_p sigm_l sigm_lp rand_est bimod b d c pow loglikelihood];    
    
    ylabels2 = {'\sigma_p', '\sigma_l', '\sigma_l/\sigma_p', 'b', 'd', 'c', '\sigma_m', '\kappa'};
     values2 = [sigm_p sigm_l sigm_lp b d c sigma_m pow];   

elseif strcmp(model,'Bayes_var')
    
    theta_p = Y(:,1); sigma_p = Y(:,2);
    sigma_l = Y(:,3:7); rand_est = Y(:,8); 
    
    %ylabels = {'\theta_p', '\sigma_p', 'mean(\sigma_l(\theta))', 'std(\sigma_l(\theta))' '\alpha', '\sigma_m', '\sigma_{l(0)}', '\sigma_{l(16)}','\sigma_{l(32)}', '\sigma_{l(48)}', '\sigma_{l(64)}'};
    %values = [theta_p sigma_p mean(sigma_l,2) std(sigma_l,0,2) rand_est sigma_m sigma_l(:,1) sigma_l(:,2) sigma_l(:,3) sigma_l(:,4) sigma_l(:,5)];
    
    ylabels = {'\theta_p', '\sigma_p', 'mean(\sigma_l(\theta))', 'std(\sigma_l(\theta))' '\alpha', '\sigma_m'};
    values = [theta_p sigma_p mean(sigma_l,2) std(sigma_l,0,2) rand_est sigma_m];

%     ylabels2 = {'\sigma_p', '\sigma_l', '\sigma_l/\sigma_p', '\sigma_m'};
%     values2 = [sigm_p sigm_l sigm_lp sigma_m];
    
    figure('WindowStyle', 'docked'); hold on; grid on
    withinsubject_errorbar([0 16 32 48 64],sigma_l); vline(32,'k--')
    set(gca, 'Xlim', [-5 70], 'Fontsize', 16);
    xlabel('Motion direction (deg)', 'Fontsize', 20)
    ylabel('\sigma_{l(\theta)}', 'Fontsize', 20)
    set(gca, 'box', 'on', 'linewidth', 1)

elseif strcmp(model,'Bayes_varmin')
    
    theta_p = Y(:,1); sigma_p = Y(:,2);
    sigma_l = Y(:,3:4); rand_est = Y(:,5); 
    
    ylabels = {'\theta_p', '\sigma_p', 'mean(\sigma_l(\theta))', '\sigma_l(all)- \sigma_l(32))' '\alpha', '\sigma_m'};
    values = [theta_p sigma_p mean(sigma_l,2) sigma_l(:,1)-sigma_l(:,2) rand_est sigma_m];
    % sigma_l(:,1) - all except 32; sigma_l(:,2) - 32 only. 
%     [h,p,ci,stats] = ttest(sigma_l(:,1), sigma_l(:,2))
%     mean(sigma_l(:,1))
%     std(sigma_l(:,1))/sqrt(size(sigma_l,1))
%     
%     [rho,p] = corr(sigma_l(:,1),AQ,'Type','Spearman')
%     
%     mean(sigma_l(:,2))
%     std(sigma_l(:,2))/sqrt(size(sigma_l,1))
end


% correlate parameters with questionnaires
figure('WindowStyle', 'docked');
for i = 1:size(values2,2)
    
    if strcmp(model, 'Bayes') || strcmp(model, 'Bayespower') || strcmp(model, 'Bayes_var') 
        subplot(1,4,i); grid on;
    else
        subplot(2,6,i); grid on;
    end
    
    [~,CI] = corr_boot(Xx,values2(:,i),1000, [xleib, ylabels2(i)],'out_keep','fig_no');
    [rho,p] = corr(Xx,values2(:,i),'Type','Spearman');
    scatter(Xx,values2(:,i),300,'k.'); lsline; grid on; %xlim([0 60])
    xlabel(xleib, 'Fontsize', 12); ylabel(ylabels2(i), 'Fontsize', 18)
    title(sprintf('\\rho = %.3f, p = %.3f \nCI(95%%) = [%.3f %.3f]', rho, p, CI(1), CI(2)))
    set(gca, 'box', 'on', 'linewidth', 1); xlim(xl)
end

if strcmp(model, 'Bayes') || strcmp(model, 'Bayespower') || strcmp(model, 'Bayes_var') 
    subplot(1,4,1); hline(32,'k:'); 
else
    subplot(2,6,1); hline(32,'k:'); 
end

if ~strcmp(model, 'Bayes2') && ~strcmp(model, 'Bayes3') && ~strcmp(model, 'Bayes') && ~strcmp(model, 'Bayespower') && ~strcmp(model, 'Bayes_var')      
    subplot(2,6,2); hline(-32,'k:');
end

% figure;
% [R21,P21] = corr(rand_est,mean(B,2),'Type','Spearman')
% scatter(rand_est,mean(B,2),200,'k.'); lsline
% xlabel('rand_est', 'Fontsize', 18); ylabel('Random estimates', 'Fontsize', 18)
% title(sprintf('r_{s} = %.3f; p = %.3f', R21, P21))

end