% estimation distributions when no stimulus displayed
%
%INPUT:
%options structure with fields -  fold:        ('on'/'off')
%                              -  session:     (1, 2, 'both')                
%                              -  stats:       ('on'/'off')                
%                              -  scatterplot: ('on'/'off')  
%                              -  lineplot:    ('on'/'off')  
%
%FIGURES
%figure 1: no stimulus distribution
%figure 2: detected vs undetected scatterplot
%
%STATS
% detected stimuli ANOVA
% undetected stimuli ANOVA

function nostim(new_opt, root, split, split_what)

%% set path and option structure
addpath(genpath('..'));
%close all
opt = struct(...
    'fold', 'off',...    %on
    'stats', 'on',...%off
    'scatterplot', 'on',...
    'lineplot', 'on'...
    );

names = fieldnames(opt);
for i = 1:numel(names)
    try
        eval(sprintf('opt.%s = new_opt.%s;', names{i}, names{i}));
    end
end

if nargin <2
    root = 'C:/Users/karve/Dropbox/MSc_project/MovingDots';
end

x = linspace(-176, 176, 23);
try 
    n_det = csvread('NostimDetected.csv');
    n_und = csvread('NostimUndetected.csv');
    n_all =  n_det + n_und;
    
catch
    
    %collect data without excluding first 100 trials
    DATA = collect_data(root,'on');

    x = linspace(-176, 176, 23);
    %% collect matrix z of 'fraction detected data'
    [n_det, n_und, n_all] = data_detect_nostim(DATA, x);
end

%% normalize histograms to optain to obtain response probability
p_det = n_det./(sum(n_det, 2)+eps);
p_und = n_und./(sum(n_und, 2)+eps);
p_all = n_all./(sum(n_all, 2)+eps);

if nargin<3
    split = 'off';
    tit = {'No-stimulus estimations'};
end

if strcmp(split,'on')
    sp=2;
else
    sp=1;
end

if strcmp(opt.fold,'on')
    x = x(12:end);
end

if strcmp(split,'on')
    p_det = n_det;
    p_und = n_und;
    p_all = n_all;
    yl = 4;    
else
    yl = 0.25;
end    

%% draw errorbar plots
if strcmp(opt.lineplot, 'on')

    for jj=1:sp % loop over high/low groups
    figure;
        for kk=1:2   % loop that fixes legend (dodgy)
            for i = 1:2 % loop through detected/undetected/all respones
                switch i
                    case 1
                        y = p_det; color = 'b';
                    case 2
                        y = p_und; color = 'r';
                    case 3
                        y = p_all; color = 'k';
                end

                if strcmp(opt.fold, 'on')
                    y = [y(:, 12) (y(:, 13:end)+y(:, 11:-1:1))/2];
                end

                if strcmp(split,'on')

                    if strcmp(split_what,'AQ')
                    Traits = csvread('Traits.csv');
                    AQ = Traits(:,3);
                    spl = median(AQ);
                    hy = y(AQ>spl,:); ly = y(AQ<spl,:);
                    yp={hy, ly}; tit = {'High AQ','Low AQ'};
                    end
                else
                    yp={y};
                end

                if strcmp(opt.fold, 'on')
                    if kk==1, prettyplot1(x, yp{jj}, color); 
                    else, prettyplot(x, yp{jj}, color); end 
                    vline(32, 'k--'); 
                    set(gca, 'xtick',  0:40:200, 'Fontsize', 16, ...
                    'Xlim', [0 176], 'Ylim',[0 .1], 'Linewidth', 1.5);     
                else
                    if kk==1, prettyplot1(x, yp{jj}, color);
                    else, prettyplot(x, yp{jj}, color); end
                    vline(32, 'k--'); vline(-32, 'k--')
                    set(gca, 'xtick',  -200:40:200, 'Fontsize', 16, ...
                    'Xlim', [-176 176], 'Ylim', [0 yl], 'Linewidth', 1.5);     
                end            
            end

            if kk==1, legend('Reported "DOTS"', 'Reported "NO DOTS"')
            end

         end

            xlabel('Angle (deg)', 'Fontsize', 20); grid on
            ylabel('Response probability', 'Fontsize', 20)
            legend('Reported "DOTS"', 'Reported "NO DOTS"')

            title(tit{jj}); hold off;

    end
end
end
