function [p_stim angles] = stim_dist

% distribution of presented motion directions (figure 2)

angles = [-64 -48 -32 -16 0 16 32 48 64];

%cont21 = 15*ones(1, 9);

contall = [20 20 110 20 20 20 110 20 20];   %cont41 = [15 15 130 15 15 15 130 15 15];

trial = contall/sum(contall); %trial = (cont21+cont41)/sum(cont21+cont41);

p_stim = trial;

figure('WindowStyle', 'docked')
plot(angles, p_stim, 'k.', 'MarkerSize', 20); hold on; grid on
plot(angles, p_stim, 'k--','LineWidth', 2)
set(gca, 'Xlim', [-70 70], 'Fontsize', 16, 'Ylim', [0 0.35], 'Fontsize', 16)
xlabel('Motion direction (deg)', 'FontSize', 20)
ylabel('Probability', 'FontSize', 20)
set(gca, 'box', 'on', 'linewidth', 2)
