function prettyplot(x, y, color)

if nargin==1
    x = 1:size(y, 2);
    color = 'k';
elseif nargin ==2
    color = 'k';
elseif nargin ==3
    if numel(x)<1
        x = 1:size(y, 2);
    end
end

N = size(y, 1);                         %number of measurements
Y = mean(y);                            %population average

%y_adjusted = y;
y_adjusted =  y - repmat(mean(y, 2), [1, size(y, 2)]); 
Y_err = std(y_adjusted)/sqrt(N);                 %within subjects standard-error

errmat = [Y'-Y_err' 2*Y_err'];          %matrix for errorbars
%  err = Y'-Y_err';
%  boundedline(x, Y, err,color)

% %figure(2)
 plot(x, Y, color, 'Linewidth', 2); hold on
 g=area(x, errmat);                                  %error bars
 set(g(1),'FaceColor', 'none', 'EdgeColor', 'none')  %make lower area-plot invisible
 set(g(2),'FaceColor', color, 'EdgeColor', 'none')   %colour for main error fill-in
 alpha(0.47);  hold on                               %make transparent (alpha 1 makes opaque,0 is completely see-through)


set(gca, 'box', 'on', 'linewidth', 1.5)