function scatter_plot(x, y, color, plotmean)

plot(x, y, sprintf('%s.', color), 'MarkerSize', 15)
Ylim = get(gca, 'Ylim');
Xlim = get(gca, 'Xlim');
hold on
plot([-10000 10000], [-10000 10000], 'k--', 'LineWidth', 1.5)

if nargin == 4
    if plotmean ==1
        
        X = mean(x); Y = mean(y);
        Xvar = std(x)/sqrt(12); Yvar = std(y)/sqrt(12);
        
        xplot = [X X, nan, X-Xvar/2 X+Xvar/2];
        yplot = [Y-Yvar/2 Y+Yvar/2 nan Y Y];
        
        plot(xplot, yplot, color, 'LineWidth', 1.5)
        
    end
end


set(gca, 'Ylim', Ylim);
set(gca, 'Xlim', Xlim);
set(gca, 'Fontsize', 14)
