function [mean_y, err_y] = withinsubject_errorbar(x, y, color)

n_angles = numel(x);
y_adjusted = y-repmat(mean(y, 2), [1, n_angles]); % + mean(mean(y, 2)); % adding grand mean does not change the err bars...
Y_err = std(y_adjusted)/sqrt(size(y,1));
Y = mean(y);

if nargin ==3
    errorbar(x, Y, Y_err, color, 'LineWidth', 2);
else
    errorbar(x, Y, Y_err, 'LineWidth', 2);
end

mean_y = Y;
err_y = Y_err;

set(gca, 'FontSize', 14)