
%% Figure 1B

% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

% loom_dat = dlmread('Fig1B.csv');
loom_dat = xlsread('Figure 1-Source Data1.xlsx',1);
%  43 columns
% 1st is time vector
% 2nd is stimulus angular size
% 3-41 are spike rasters
% 42-43 are mean and sem of the IFR

figure; ah=gca;
plot(ah, loom_dat(:,1),loom_dat(:,2) )
ah.YLabel.String = '2*theta ()';
ah.XLabel.String = 'Time to collision (s)';
xlim(ah,[-2.6,0.25])

figure; hold on
ah = gca;
[row,col]=find(loom_dat(:,3:41));
t_val = loom_dat(row,1);
y_vect = [col'-0.5; col'+0.4];
line([t_val'; t_val'], y_vect, 'Parent', ah, 'LineWidth', 0.5, 'Color', 'k');
ah.XLabel.String = 'Time to collision (s)';
ah.YTick = [];
xlim(ah,[-2.6,0.25])

figure; ah=gca;
ErrorPlot(loom_dat(:,1),loom_dat(:,42), loom_dat(:,43), ah,0,'k' )
ah.YLabel.String = 'LGMD f (spk/s)';
ah.XLabel.String = 'Time to collision (s)';
xlim(ah,[-2.6,0.25])

%% Figure 1F of Dewell & Gabbiani 2018
% comparison of behavioral response to looming stimuli of varying spatial coherence

% jump_dat = dlmread('Fig1F.csv');
jump_dat = xlsread('Figure 1-Source Data1.xlsx',2);
% 3 columns: 1st is coherence, 2nd is jump %, 3rd is sem of jump pct

figure; hold on
ErrorBars(jump_dat(:,1), jump_dat(:,2), jump_dat(:,3), gca, '.k')
linear_plotter(jump_dat(1:9,1), jump_dat(1:9,2), gcf, 'k', 'none')
xlim([-1 101])
ylim([0 0.75])
ah=gca;
ah.XTick=0:10:100;
ah.XTickLabel = {'0','','20','','40','','60','','80','','100'};
ah.YTick=0:0.1:0.7;
ah.YTickLabel = {'0','10','20','30','40','50','60','70'};
xlabel(ah,'Looming stimulus coherence (%)')
ylabel(ah,'Jump probability (%)')

[r_coh_jump,p_coh_jump] = corr(jump_dat(1:9,1),jump_dat(1:9,2));

%% Figure 1G of Dewell & Gabbiani 2018
% comparison of LGMD spike responses to 100% and 0% spatial coherence looming stimuli

% spike_dat = dlmread('Fig1G.csv');
spike_dat = xlsread('Figure 1-Source Data1.xlsx',3);
% 4 columns: 1 is coarse spike count, 2nd is 0% coherence spike count
%	3 and 4 are coarse and 0% coherent peak firing rate

N = size(spike_dat,1);

figure; hold on
ah = gca;
line([ones(N,1),ones(N,1)*2]',spike_dat(:,1:2)', 'Color', 'k')
plot(ah,[ones(N,1),ones(N,1)*2],spike_dat(:,1:2),'.','Color','k','MarkerSize', 26)
ylabel('LGMD response (spk)')
ah.XTick=[1,2];
ah.XTickLabel = {'Coarse loom','Incoherent loom'};

figure; hold on
ah = gca;
line([ones(N,1),ones(N,1)*2]',spike_dat(:,3:4)', 'Color', 'k')
plot(ah,[ones(N,1),ones(N,1)*2],spike_dat(:,3:4),'.','Color','k','MarkerSize', 26)
ylabel('LGMD peak rate (spk/s)')
ah.XTick=[1,2];
ah.XTickLabel = {'Coarse loom','Incoherent loom'};

[p_incoh_spk,~,stats_spk] = ranksum( spike_dat(:,1),spike_dat(:,2));
[p_incoh_pk,~,stats_pk] = ranksum( spike_dat(:,3),spike_dat(:,4));


