% Figure 2 of Dewell & Gabbiani 2018
% HCN channels in dendritic field A responsible for spatial coherence sensitivity

% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

%% Figure 2B
% removal sags after ZD7288 application

% zd_traces = dlmread('Fig2B.csv');
zd_traces = xlsread('Figure 2-Source Data1.xlsx',1);
% 11 columns:
% 1st is time vector (0 is start of current step)
% 2-6 are control traces
% 7-11 are ZD7288 traces

figure; hold on
ah=gca;
plot(ah,zd_traces(:,1),zd_traces(:,2:6),'k')
plot(ah,zd_traces(:,1),zd_traces(:,7:11),'r')
xlim([-0.2 1.5])
ylabel(ah,'Vm (mV)')


%% Figure 2C
% sags recorded from different dendritic regions

% traces = dlmread('Fig2C.csv');
traces = xlsread('Figure 2-Source Data1.xlsx',2);
% 7 columns:
% 1st is time vector (0 is start of current step)
% 2-3 are control trace mean and sd
% 4-5 are trunk trace mean and sd
% 6-7 are field C trace mean and sd

figure; hold on
ah=gca;
ErrorPlot(traces(:,1),traces(:,6), traces(:,7), ah,0,'m' )
ErrorPlot(traces(:,1),traces(:,4), traces(:,5), ah,0,'b' )
ErrorPlot(traces(:,1),traces(:,2), traces(:,3), ah,0,'g' )

xlim([-0.2 2.0])
ylabel(ah,'Vm (mV)')


%% Figure 2D
% comparison of sag amplitude in different dendritic regions

% sag_dat = dlmread('Fig2D.csv');
sag_dat = xlsread('Figure 2-Source Data1.xlsx',3);
% 4 columns:
% 1st is field A control, 2nd is field A ZD7288, 3rd is trunk, 4th is fields B,C

ErrorBars([0.8,1.2,2,3],nanmedian(sag_dat), mad(sag_dat,1), '.k')
xlim([0.5 3.5])
ylim([0 21])
ah=gca;
ah.XTick = 1:3;
ah.XTickLabel = {'Field A','Trunk','Fields B,C'};
ah.YTick=0:5:20;
ylabel(ah,'Sag (mV)')

[p_sag_bin,sag_tbl,stats] = kruskalwallis(sag_dat,[],'off');
c_sag = multcompare(stats,'Display','off');

%% Figure 2E
% comparison of sag time constant in different dendritic regions

% tau_dat = dlmread('Fig2E.csv');
tau_dat = xlsread('Figure 2-Source Data1.xlsx',4);
% 4 columns:
% 1st is field A control, 2nd is field A ZD7288, 3rd is trunk, 4th is fields B,C

ErrorBars([0.8,1.2,2,3],nanmedian(tau_dat), mad(tau_dat), '.k')
xlim([0.5 3.5])
ylim([0 2.5])
ah=gca;
ah.XTick = 1:3;
ah.XTickLabel = {'Field A','Trunk','Fields B,C'};
ah.YTick=0:0.5:2.5;
ylabel(ah,'tau sag (s)')

[p_tau_bin,tau_tbl,stats] = kruskalwallis(sag_dat,[],'off');
c_sagtau = multcompare(stats,'Display','off');

%% Figure 2F
% sag amplitude by distance from siz (bAP)

% bAP_sag = dlmread('Fig2F.csv');
bAP_sag = xlsread('Figure 2-Source Data1.xlsx',5);

linear_plotter(bAP_sag(:,1),bAP_sag(:,2))
xlabel('bAP amplitude (mV)')
ylabel('Sag amplitude (mV)')

[r,p] = corr(bAP_sag(:,1),bAP_sag(:,2));

%% Figure 2G
% gH activation curve

% VC_ih = dlmread('Fig2G.csv');
VC_ih = xlsread('Figure 2-Source Data1.xlsx',6);
% 5 columns:
% 1-2 are Vm and Ih data field A control
% 3-4 are Vm and Ih values for control data fit
% 5 is fit for cAMP data

figure; hold on
scatter( VC_ih(:,1), VC_ih(:,2), 30, 'k','filled' )
line( VC_ih(:,3), VC_ih(:,4), 'Color', 'k')
line( VC_ih(:,3), VC_ih(:,5), 'Color', 'b')
xlim([-150 -30])
ylim([0 1.1])
ah=gca;
ah.XTick = -150:30:-30;
ah.YTick = 0:0.25:1;
ylabel(ah,'gH (% max)')
xlabel(ah,'Membrane potential (mV)')


%% Figure 2H
% comparison of sag time constant in different dendritic regions

% VC_tau = dlmread('Fig2H.csv');
VC_tau = xlsread('Figure 2-Source Data1.xlsx',7);
% 4 columns:
% 1-2 are Vm and Ih tau data field A control
% 3-4 are Vm and tau values for data fit

figure; hold on
scatter( VC_tau(:,1), VC_tau(:,2),30,'k','filled' )
line( VC_tau(:,3), VC_tau(:,4), 'Color', 'k')
xlim([-150 -30])
ah=gca;
ah.XTick=[-150,-120,-90,-60,-30];
ah.YTick=[0 0.5 1 1.5 2];
ylabel(ah,'tau H (s)')
xlabel(ah,'Membrane potential (mV)')

%% Figure 2I

% oar = dlmread('Fig2I.csv');
oar = xlsread('Figure 2-Source Data1.xlsx',8);
figure;
ah=gca;
ErrorBars(1:3, oar(1,:), oar(2,:),ah, '.k')
ylim([0 45])
ylabel(ah,'Activation at rest (%)')
ah.XTick = 1:3;
ah.XTickLabel = {'control','cAMP','ZD7288'};

ah.YTick=0:5:45;
ah.YTickLabel = {'0','','10','','20','','30','','40',''};

%% Fig 2J

% zd_loom = dlmread('Fig2J.csv');
zd_loom = xlsread('Figure 2-Source Data1.xlsx',9);
% 8 columns
% 1st is time vector
% 2nd is stimulus angular size
% 3 is Vm trace for example control response
% 4 is Vm trace for example ZD response
% 5-6 are mean and sem of the IFR after puffing ZD7288
% 7 is mean IFR for intracellular ZD
% 8 is mean IFR of control

figure; ah=gca;
plot(ah, zd_loom(:,1),zd_loom(:,2) )
ah.YLabel.String = '2*theta ()';
ah.XLabel.String = 'Time to collision (s)';
xlim(ah,[-2.6,0.25])

figure; hold on
ah=gca;
plot(ah, zd_loom(:,1),zd_loom(:,3), 'k' )
plot(ah, zd_loom(:,1),zd_loom(:,4), 'r')
ah.YLabel.String = 'Vm (mV)';
ah.XLabel.String = 'Time to collision (s)';
xlim(ah,[-2.6,0.25])

figure; hold on
ah=gca;
ErrorPlot(zd_loom(:,1),zd_loom(:,5), zd_loom(:,6), ah,0,'r' )
plot(ah, zd_loom(:,1),zd_loom(:,7), '--r')
plot(ah, zd_loom(:,1),zd_loom(:,8), 'k')
ah.YLabel.String = 'LGMD f (spks/s)';
ah.XLabel.String = 'Time to collision (s)';
xlim(ah,[-2.6,0.25])

%% Figure 2K

% coh_mat = dlmread('Fig2K.csv');
coh_mat = xlsread('Figure 2-Source Data1.xlsx',10);
% 21 columns
% 1st is coherence values
% 2-11 are control mean spike counts
% 12-21 are mean spike counts after ZD7288

N = 10;

fh = figure; hold on
ah2 = gca;
ah2.Title.String = 'without standard loom';
ah2.YLabel.String = 'LGMD spike count';
ah2.XLabel.String = 'Stimulus coherence (%)';

nstim = size(coh_mat,1);
for n=1:N
	linear_plotter( coh_mat(:,1), coh_mat(:,1+n), fh, 'k', 'none' )
	linear_plotter( coh_mat(:,1), coh_mat(:,11+n), fh, 'r', 'none' )
end
ErrorBars( coh_mat(:,1), nanmean(coh_mat(:,2:11),2), ...
	nanstd(coh_mat(:,2:11),[],2)./N^0.5, ah2, '.k', 'linear')
ErrorBars( coh_mat(:,1), nanmean(coh_mat(:,12:21),2), ...
	nanstd(coh_mat(:,12:21),[],2)./N^0.5, ah2, '.r', 'linear')

ah2.YLim = [0,80];
ah2.XLim = [-1,101];

%% Figure 2L

% coh_slopes = dlmread('Fig2L.csv');
coh_slopes = xlsread('Figure 2-Source Data1.xlsx',11);
N = size(coh_slopes,1);

fh1 = figure; hold on
ah = gca;
ah.Title.String = 'Spk ct (average)';
line(ah,[ones(N,1),ones(N,1)*2]',coh_slopes','Color',[0.6,0.6,0.6])
ErrorBars( [1,2], median(coh_slopes), mad(coh_slopes), ah, '.k', 'linear')

ah.XLim = [0.8,2.2];
ah.XTick=[1 2];
ah.XTickLabel = {'Control','ZD7288'};
ah.YLabel.String = 'Coherence preference (spks/% coh)';


%% Figure 2M

% norm_coh = dlmread('Fig2M.csv');
norm_coh = xlsread('Figure 2-Source Data1.xlsx',12);

fh1 = figure; hold on
ah = gca;
ah.YLabel.String = 'LGMD response (% max)';
ah.XLabel.String = 'Stimulus coherence (%)';

ErrorBars( norm_coh(1:end-1,1), norm_coh(1:end-1,2), norm_coh(1:end-1,3), ah, '.k', 'linear')
ErrorBars( norm_coh(1:end-1,1), norm_coh(1:end-1,4), norm_coh(1:end-1,5), ah, '.r', 'linear')
ErrorBars(100, norm_coh(end,2), norm_coh(end,3), ah, '.k')
scatter(ah, 100, norm_coh(end,2), 100, 'filled','p', 'MarkerFaceColor', 'k')
ErrorBars(100, norm_coh(end,4), norm_coh(end,5), ah, '.r')
scatter(ah, 100, norm_coh(end,4), 100, 'filled','p', 'MarkerFaceColor', 'r')
ah.XLim = [-1,101];
ah.YLim = [0,102];

%% Figure 2N

% spkchg_jump = dlmread('Fig2N.csv');
spkchg_jump = xlsread('Figure 2-Source Data1.xlsx',13);

figure; hold on
linear_plotter( spkchg_jump(:,1), spkchg_jump(:,2), gcf, 'k')
scatter( spkchg_jump(end,1), spkchg_jump(end,2), 100, 'filled','p', 'MarkerFaceColor', 'k')
ylim([0 70])
xlabel('Decrease in spikes after gH block (%)')
ylabel('Jump probability (%)')

[r_jump_rigzd,p_jump_rigzd] = corr(spkchg_jump(:,1), spkchg_jump(:,2));

