%% Figure 2-S1
% Current and voltage clamp traces and Cs+ data


% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

%% Figure 2-S1A
% Current clamp traces before and after Cs+

% cc_cscl = dlmread('Fig2-S1A.csv');
cc_cscl = xlsread('Figure 2-Source Data2.xlsx',1);
% 9 columns
% 1st is time vector

figure; hold on
ah=gca;
plot(ah, cc_cscl(:,1),cc_cscl(:,6:9), 'k' )
plot(ah, cc_cscl(:,1),cc_cscl(:,2:5), 'Color', [0.7,0.5,0.5] )

ah.YLabel.String = 'Vm (mV)';
ah.XLabel.String = 'Time from current onset (s)';
xlim(ah,[-0.1,1.3])

% cc_sag = dlmread('Fig2-S1A2.csv');
cc_sag = xlsread('Figure 2-Source Data2.xlsx',2);

figure; hold on
ah=gca;
ErrorBars( cc_sag(1,:), cc_sag(2,:), ah,'.k')
ylabel(ah, 'Sag (mV)')
ah.XTick = [1,2];
ah.XTickLabel = {'Control','Cs^+'};
ah.YTick = 0:5:20;
ylim(ah,[0,22])

%% Figure 2-S1B
% Voltage clamp traces before and after Cs+

% vc_cscl = dlmread('Fig2-S1B.csv');
vc_cscl = xlsread('Figure 2-Source Data2.xlsx',3);
% 7 columns
% 1st is time vector

figure; hold on
ah=gca;
plot(ah, vc_cscl(:,1),vc_cscl(:,2:4), 'k' )
plot(ah, vc_cscl(:,1),vc_cscl(:,5:7), 'Color', [0.7,0.5,0.5] )

ah.YLabel.String = 'Im (nA)';
ah.XLabel.String = 'Time from voltage onset (s)';
xlim(ah,[-0.1,2.3])


%% Figure 2-S1C
% current clamp traces

% cc_trace = dlmread('Fig2-S1C.csv');
cc_trace = xlsread('Figure 2-Source Data2.xlsx',4);
% 16 columns
% 1st is time vector

figure; hold on
ah=gca;
plot(ah, cc_trace(:,1),cc_trace(:,4:3:end), 'k' )
plot(ah, cc_trace(:,1),cc_trace(:,2:3:end), 'g' )
plot(ah, cc_trace(:,1),cc_trace(:,3:3:end), 'g' )

ah.YLabel.String = 'Vm (mV)';
ah.XLabel.String = 'Time from current onset (s)';
xlim(ah,[-0.2,3.0])


%% Figure 2-S1D
% voltage clamp traces

% vc_trace = dlmread('Fig2-S1D.csv');
vc_trace = xlsread('Figure 2-Source Data2.xlsx',5);

% 22 columns
% 1st is time vector

figure; hold on
ah=gca;
plot(ah, vc_trace(:,1),vc_trace(:,4:3:end), 'k' )
plot(ah, vc_trace(:,1),vc_trace(:,2:3:end), 'g' )
plot(ah, vc_trace(:,1),vc_trace(:,3:3:end), 'g' )

ah.YLabel.String = 'Im (nA)';
ah.XLabel.String = 'Time from start of voltage step (s)';
xlim(ah,[-0.2,3.0])
