%% Figure 2-S2 of Dewell and Gabbiani 2018 

% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

%% Figure 2-S2A
% example LGMD flash responses before vs after ZD7288 puffing

% trace_vm = dlmread('Fig2-S2A.csv');
trace_vm = xlsread('Figure 2-Source Data3.xlsx',1);
% 7 columns
% 1st is time vector
% 2-3 are response to first flash location before and after ZD
% 4-5 are response to second flash location before and after ZD
% 6-7 are response to third flash location before and after ZD

figure; hold on
ah = gca;
plot(ah,trace_vm(:,1),trace_vm(:,4),'g')
plot(ah,trace_vm(:,1),trace_vm(:,5),'r')
ah.XLim = [0.04,0.2];
ah.XLabel.String = 'Time from flash onset';
ah.YLabel.String = 'Membrane potential (mV)';

figure; hold on
ah = gca;
plot(ah,trace_vm(:,1),trace_vm(:,2),'g')
plot(ah,trace_vm(:,1),trace_vm(:,3),'r')
ah.XLim = [0.04,0.2];
ah.XLabel.String = 'Time from flash onset';
ah.YLabel.String = 'Membrane potential (mV)';

figure; hold on
ah = gca;
plot(ah,trace_vm(:,1),trace_vm(:,6),'g')
plot(ah,trace_vm(:,1),trace_vm(:,7),'r')
ah.XLim = [0.04,0.2];
ah.XLabel.String = 'Time from flash onset';
ah.YLabel.String = 'Membrane potential (mV)';

%% Figure 2-S2B
% difference in flash response (spikes count) before vs after ZD7288 puffing

% spk_diff = dlmread('Fig2-S2B.csv');
spk_diff = xlsread('Figure 2-Source Data3.xlsx',2);

figure; ah = gca;
histogram(ah, spk_diff)
ah.XLim = [-4,4];
ah.XLabel.String = 'Change in spike count';
ah.YLabel.String = 'Number of trials';


%% Figure 2-S2C
% difference in flash response (peak depolarization) before vs after ZD7288 puffing

% vm_diff = dlmread('Fig2-S2C.csv');
vm_diff = xlsread('Figure 2-Source Data3.xlsx',3);

figure; ah = gca;
histogram(ah, vm_diff, 16)
ah.XLim = [-13,13];
ah.XLabel.String = 'Change in peak depolarization (mV)';
ah.YLabel.String = 'Number of trials';

%% Fig 2-S2D
% LGMD response to stimulus coherence (peak firing rate)

% coh_ifr = dlmread('Fig2-S2D.csv');
coh_ifr = xlsread('Figure 2-Source Data3.xlsx',4);
% 21 columns
%  1st is coherence
% 2-11 are control mean peak IFR values
% 12-21 are mean peak IFR after ZD7288

N = 10;
ns = size(coh_ifr,1);

fh = figure; hold on
ah2 = gca;
ah2.YLabel.String = 'LGMD peak IFR (spk/s)';
ah2.XLabel.String = 'Stimulus coherence (%)';

nstim = size(coh_ifr,1);
for n=1:N
	linear_plotter( coh_ifr(:,1), coh_ifr(:,1+n), fh, [0.6,0.6,0.6],...
		'none',[], 0.5 )
	linear_plotter( coh_ifr(:,1), coh_ifr(:,11+n), fh, 'r','none',[],0.5 )
end
ErrorBars( coh_ifr(1:ns-1,1), nanmean(coh_ifr(1:ns-1,2:11),2), ...
	nanstd(coh_ifr(1:ns-1,2:11),[],2)./N^0.5, ah2, '.k', 'linear')
ErrorBars( coh_ifr(1:ns-1,1), nanmean(coh_ifr(1:ns-1,12:21),2), ...
	nanstd(coh_ifr(1:ns-1,12:21),[],2)./N^0.5, ah2, '.r', 'linear')

ErrorBars(100,nanmean(coh_ifr(end,2:11),2), nanstd(coh_ifr(end,2:11),[],2)./N^0.5, ah2, 'pk')
ErrorBars(100,nanmean(coh_ifr(end,12:21),2), nanstd(coh_ifr(end,12:21),[],2)./N^0.5, ah2, 'pr')

ah2.YLim = [0,160];
ah2.XLim = [-1,101];

%% Figure 2-S2E
% coherence preference using IFR

% ifr_pref = dlmread('Fig2-S2E.csv');
ifr_pref = xlsread('Figure 2-Source Data3.xlsx',5);
N = size(ifr_pref,1);

fh3 = figure; hold on
ah3 = gca;
line(ah3, [ones(N,1),ones(N,1)*2]',ifr_pref','Color',[0.6,0.6,0.6])
ErrorBars( [1,2], mean(ifr_pref), std(ifr_pref), ah3, '.k', 'linear')

ah3.Title.String = 'Peak IFR (average)';
ah3.XLim = [0.9,2.1];
ah3.XTick=[1 2];
ah3.XTickLabel = {'Control','ZD7288'};
ah3.YLabel.String = 'Coherence preference (spk/s/% coh)';

%% Figure 2-S2F
% coherence preference with Cs+

% coh_pref_cs = dlmread('Fig2-S2F.csv');
coh_pref_Cs = xlsread('Figure 2-Source Data3.xlsx',6);
N = size(coh_pref_Cs,1);

fh1 = figure; hold on
ah = gca;
line([ones(N,1),ones(N,1)*2]',coh_pref_Cs','Color',[0.6,0.6,0.6])
ErrorBars( [1,2], median(coh_pref_Cs), mad(coh_pref_Cs), ah, '.k', 'linear')

ah.XLim = [0.8,2.2];
ah.XTick=[1 2];
ah.XTickLabel = {'Control','Cs^+'};
ah.YLabel.String = 'Coherence preference (spk/% coh)';

%% Figure 2-S2F
% gH block reduction in loom response for different l/|v|

% lv_chg = dlmread('Fig2-S2G.csv');
lv_chg = xlsread('Figure 2-Source Data3.xlsx',7);
% 3 columns
% 1st is l/|v| value (ms)
% 2nd is % change in spike count 
% 3rd is % change in peak ifr 

figure; hold on
ah=gca;

linear_plotter( lv_chg(:,1), lv_chg(:,2), ah, [0.5,0.5,0.5],'.',30, 2 )
linear_plotter( lv_chg(:,1), lv_chg(:,3), ah, 'k','.',30, 2 )
ah.XLim = [10,90];
ah.YLim = [20,55];
xlabel(ah,'l/|v| (ms)')
ylabel(ah,'Change in loom response after gH blockade (%)')
legend(ah,'','Spike count','','peak IFR', 'Location', 'northwest')

