% Figure 3 of Dewell & Gabbiani 2018
% Blocking HCN channels removed coherence preference of escape behavior

% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

%% Figure 3A
% Jump percent for 100% and 86% coherent stimuli after saline and ZD7288

% jumps = dlmread('Fig3A.csv');
jumps = xlsread('Figure 3-Source Data1.xlsx',1);
% 4 columns (each is mean, lower confidence interval, upper ci)
% 1st is saline loom
% 2nd is ZD7288 loom
% 3rd is saline 86% coherent
% 4th is ZD7288 86% coherent

figure
ah=gca;
ErrorBars([1,4]',jumps(1,[1,3])', jumps(2:3,[1,3])', ah,'.k')
ErrorBars([2,5]',jumps(1,[2,4])', jumps(2:3,[2,4])', ah,'.r')
ylim(ah,[0,65])
ylabel(ah, 'Jump probability (%)')
ah.XTick = [1.5,4.5];
ah.XTickLabel = {'Loom', '86% coherent'};
ah.YTick = 0:10:60;


%% Figure 3B
% Instantaneous firing rates for 100% and 86% coherent stimuli during jump
% experiments with ZD7288

% ifr_dat = dlmread('Fig3B.csv');
ifr_dat = xlsread('Figure 3-Source Data1.xlsx',2);
% 9 columns:
% 1st is time vector
% 2,3 are mean and sd of 100% coherent loom control
% 4,5 are mean and sd of 100% coherent loom after ZD7288
% 6,7 are mean and sd of 86% coherent loom control
% 8,9 are mean and sd of 86% coherent loom after ZD7288

figure;
ah=gca;
ErrorPlot(ifr_dat(:,1), ifr_dat(:,2), ifr_dat(:,3), ah,0,'k')
ErrorPlot(ifr_dat(:,1), ifr_dat(:,4), ifr_dat(:,5), ah,0,'r')
xlim(ah,[-3 0.2])
ylim(ah,[0 350])

figure;
ah2=gca;
ErrorPlot(ifr_dat(:,1), ifr_dat(:,6), ifr_dat(:,7), ah2,0,'k')
ErrorPlot(ifr_dat(:,1), ifr_dat(:,8), ifr_dat(:,9), ah2,0,'r')
xlim(ah2,[-3 0.2])
ylim(ah2,[0 350])

ylabel(ah,'Lgmd f (spks/s)')
ylabel(ah2,'Lgmd f (spks/s)')

xlabel(ah,'Time relative to collision (s)')
xlabel(ah2,'Time relative to collision (s)')

title(ah,'Standard loom')
title(ah2,'86% coherent loom')


%% Figure 3C
% Example recordings for 100% and 86% coherent stimuli during jump
% experiments with ZD7288

% dcmd_dat = dlmread('Fig3C.csv');
dcmd_dat = xlsread('Figure 3-Source Data1.xlsx',3);
% 5 columns:
% 1st is time vector
% 2,3 are 100% and 86% coherent looms control
% 4,5 are 100% and 86% coherent looms after ZD7288 injection

figure; ah=gca;
plot(ah, dcmd_dat(:,1), dcmd_dat(:,2),'k')
xlabel(ah,'Time relative to collision (s)')
ylabel(ah,'voltage (V)')
title(ah,'Standard loom')
xlim(ah,[-3 0.2])
ylim(ah,[-200 150])

figure; ah=gca;
plot(ah, dcmd_dat(:,1), dcmd_dat(:,3),'k')
xlabel(ah,'Time relative to collision (s)')
ylabel(ah,'voltage (V)')
title(ah,'86% coherent loom')
xlim(ah,[-3 0.2])
ylim(ah,[-200 150])

figure; ah=gca;
plot(ah, dcmd_dat(:,1), dcmd_dat(:,4),'r')
xlabel(ah,'Time relative to collision (s)')
ylabel(ah,'voltage (V)')
title(ah,'Standard loom')
xlim(ah,[-3 0.2])
ylim(ah,[-200 150])

figure; ah=gca;
plot(ah, dcmd_dat(:,1), dcmd_dat(:,5),'r')
xlabel(ah,'Time relative to collision (s)')
ylabel(ah,'voltage (V)')
title(ah,'86% coherent loom')
xlim(ah,[-3 0.2])
ylim(ah,[-200 150])

%% Figure 3D
% Rasters and instantaneous firing rates for standard loom control and after
% stereotactic ZD7288 injection

% szd_dat = dlmread('Fig3D.csv');
szd_dat = xlsread('Figure 3-Source Data1.xlsx',4);
% 13 columns:
% 1st is time vector
% 2,3 are mean and sd of control
% 4,5 are mean and sd after ZD7288
% 6-10 are rasters for control
% 11-13 are rasters for after ZD7288

figure;
ah=subplot(2,1,2);
ah2 = subplot(2,1,1);

ErrorPlot(szd_dat(:,1), szd_dat(:,2), szd_dat(:,3), ah,0,'k')
ErrorPlot(szd_dat(:,1), szd_dat(:,4), szd_dat(:,5), ah,0,'r')
xlim(ah,[-2 0.45])
ylim(ah,[0 220])
ah.YTick=0:50:200;

ylabel(ah,'Firing frequency (spks/s)')
xlabel(ah,'Time relative to collision (s)')

y_vect = [0.5:4.5; 1.4:5.4];
[spki, col] = find( szd_dat(:,6:10) );
t_val = szd_dat(spki,1);
line([t_val'; t_val'], y_vect(:,col), 'Parent', ah2, 'Color', 'k')

y_vect = [6:8; 6.9:8.9];
[spki, col] = find( szd_dat(:,11:13) );
t_val = szd_dat(spki,1);
line([t_val'; t_val'], y_vect(:,col), 'Parent', ah2, 'Color', 'r')
ah2.XTick=[];
ah2.YTick=[];
