% Figure 3 figure supplement 1 of Dewell & Gabbiani 2018
% Change in escape behavior due to gH blockade within the LGMD

% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

%% Figure 3-S1B
% Jump percent unchanged by attaching recording wires

% jumps = dlmread('Fig3S1B.csv');
jumps = xlsread('Figure 3-Source Data2.xlsx',1);
% 2 columns (each is mean, lower confidence interval, upper ci)
% 1st is control loom
% 2nd is wired loom

figure
ah=gca;
ErrorBars([1,2]',jumps(1,:)', jumps(2:3,:)', ah,'.k')
ylim(ah,[0,81])
ylabel(ah, 'Jump probability (%)')
ah.XTick = [1,2];
ah.XTickLabel = {'Control', 'Wired'};
ah.YTick = 0:10:80;

%% Figure 3-S1C
% Instantaneous firing rates were not altered by stereotactic injection
% procedure

% spk_dat = dlmread('Fig3S1C.csv');
spk_dat = xlsread('Figure 3-Source Data2.xlsx',2);
% 4 columns:
% 1 and 2 are spike counts for control and after pipette penetration
% 3 and 4 are peak spike rates for control and after pipette penetration

xval = repmat([1,2],6,1);

figure; hold on
ah=gca;
line(ah, xval', spk_dat(:,1:2)','Color',[0.6,0.6,0.6])
scatter(ah,xval(:,1),spk_dat(:,1),36,'k','filled')
scatter(ah,xval(:,2),spk_dat(:,2),36,'k','filled')
xlim(ah,[0.9 2.1])
ylim(ah,[50 100])
ylabel(ah,'Response (# spk)')
ah.XTick = 1:2;
ah.XTickLabel = {'Control','Penetration'};
ah.YTick = 50:10:100;

figure; hold on
ah2=gca;
line(ah2, xval', spk_dat(:,3:4)','Color',[0.6,0.6,0.6])
scatter(ah2, xval(:,1), spk_dat(:,3),36,'k','filled')
scatter(ah2, xval(:,2), spk_dat(:,4),36,'k','filled')
xlim(ah2,[0.9 2.1])
ylim(ah2,[100 260])
ylabel(ah2,'Peak f (spk/s)')
ah2.XTick = 1:2;
ah2.XTickLabel = {'Control','Penetration'};
ah2.YTick = 100:20:260;

p_eye_fr = signrank( spk_dat(:,3), spk_dat(:,4) );
p_eye_ct = signrank( spk_dat(:,1), spk_dat(:,2) );
