% Figure 4 of Dewell & Gabbiani 2018
% comparison of electrotonic membrane properties and temporal summation before
% and after ZD7288 application

% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

%% Figure 4A
% comparison of restimg membrane potential before and after ZD7288

% rmp_dat = dlmread('Fig4A.csv');
rmp_dat = xlsread('Figure 4-Source Data1.xlsx',1);
% 2 columns:
% 1st is field A control, 2nd is field A ZD7288

figure;
boxplot(rmp_dat, {'control', 'ZD7288'}, 'notch', 'on')
ah=gca;
ah.YLim = [-80 -59];
ah.YTick = -80:10:-60;
ylabel(ah,'RMP (mV)')

[p_rmp,~,stats_rmp] = ranksum( rmp_dat(:,1),  rmp_dat(:,2) );


%% Figure 4B
% comparison of input resistance before and after ZD7288

% Ri_dat = dlmread('Fig4B.csv');
Ri_dat = xlsread('Figure 4-Source Data1.xlsx',2);
% 2 columns:
% 1st is field A control, 2nd is field A ZD7288

figure
boxplot(Ri_dat, {'control', 'ZD7288'}, 'notch', 'on')
ah=gca;
ah.YLim = [0 15];
ah.YTick = 0:5:15;
ylabel(ah,'Ri (M\Omega)')

[p_Ri,~,stats_Ri] = ranksum( Ri_dat(:,1),  Ri_dat(:,2) );

%% Figure 4C
% comparison of membrane time constant before and after ZD7288

% Taum_dat = dlmread('Fig4C.csv');
Taum_dat = xlsread('Figure 4-Source Data1.xlsx',3);
% 2 columns:
% 1st is field A control, 2nd is field A ZD7288

figure
boxplot(Taum_dat, {'control', 'ZD7288'}, 'notch', 'on')
ah=gca;
ah.YLim = [0 15];
ah.YTick = 0:5:15;
ylabel(ah,'tau_M (ms)')

[p_Taum,~,stats_Taum] = ranksum( Taum_dat(:,1),  Taum_dat(:,2) );

%% Figure 4E
% comparison of temporal summation sEPSP before and after ZD7288

% sum_dat = dlmread('Fig4E.csv');
sum_dat = xlsread('Figure 4-Source Data1.xlsx',4);
% 11 columns:
% 1-2 are ipis and summation field A control
% 3-4 are ipis and summation field A ZD7288
% 5-6 are ipis and mean summation field A control
% 7-8 are ipis and mean summation field A ZD7288
% 9 is the ipi vector for exponential fits
% 10 values of exponential fit field A control
% 11 values of exponential fit field A ZD7288

figure; hold on
scatter(sum_dat(:,1),sum_dat(:,2),20,'k', 'filled')
scatter(sum_dat(:,3),sum_dat(:,4),20,'r', 'filled')
scatter(sum_dat(:,5),sum_dat(:,6),80,'k', 'filled')
scatter(sum_dat(:,7),sum_dat(:,8),80,'r', 'filled')
plot(sum_dat(:,9),sum_dat(:,10),'k')
plot(sum_dat(:,9),sum_dat(:,11),'r')
ylabel('Summation (%)')
xlabel('Interpulse interval (ms)')

%% Figure 4F
% comparison of mean input resistance for sEPSP before and after ZD7288

% Rtot_dat = dlmread('Fig4F.csv');
Rtot_dat = xlsread('Figure 4-Source Data1.xlsx',5);
% 4 columns:
% 1st is field A control, 2nd is field A ZD7288
% columns 3 and 4 are individual means before and after ZD7288

figure; hold on
scatter(ones(size(Rtot_dat(:,1))), Rtot_dat(:,1), 40,'g')
scatter(ones(size(Rtot_dat(:,2)))*2, Rtot_dat(:,2), 40,'r')
indv = Rtot_dat(1:6,3:4);
line([1,2],indv,'Color',[0.6,0.6,0.6])
line([1,2],mean(indv),'Color','k','LineWidth',2)
ah=gca;
ah.YLim = [0 23];
ah.YTick = 0:5:20;
ylabel(ah,'Mean resistance (M\Omega)')
ah.XTick = 1:2;
ah.XTickLabel = {'Control','ZD7288'};

[p_Rtot,~,stats_Rtot] = ranksum( Rtot_dat(:,1),  Rtot_dat(:,2) );
