% Figure 5 of Dewell & Gabbiani 2018
% A 4AP-sensitive K+ conductance decreases responses to incoherent stimuli.

% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

%% Fig 5A

% ap4_loom = dlmread('Fig5A.csv');
ap4_loom = xlsread('Figure 5-Source Data1.xlsx',1);
% 8 columns
% 1st is time vector
% 2nd is stimulus angular size
% 3 is Vm trace for example control response
% 4 is Vm trace for example 4AP response
% 5-6 are IFR of before and after intracellular 4AP
% 7-8 are IFR of before and after extracellular 4AP

figure; ah=gca;
plot(ah, ap4_loom(:,1),ap4_loom(:,2) )
ah.YLabel.String = '2*theta ()';
ah.XLabel.String = 'Time to collision (s)';
xlim(ah,[-2.6,0.25])

figure; hold on
ah=gca;
plot(ah, ap4_loom(:,1),ap4_loom(:,3), 'k' )
plot(ah, ap4_loom(:,1),ap4_loom(:,4), 'b')
ah.YLabel.String = 'Vm (mV)';
ah.XLabel.String = 'Time to collision (s)';
xlim(ah,[-2.6,0.25])

figure; hold on
ah=gca;
plot(ah, ap4_loom(:,1),ap4_loom(:,5), '--b')
plot(ah, ap4_loom(:,1),ap4_loom(:,6), '--k')
plot(ah, ap4_loom(:,1),ap4_loom(:,7), 'k')
plot(ah, ap4_loom(:,1),ap4_loom(:,8), 'b')
ah.YLabel.String = 'LGMD f (spks/s)';
ah.XLabel.String = 'Time to collision (s)';
xlim(ah,[-2.6,0.25])


%% Figure 5B
% LGMD responses to looming stimulus coherence before and after 4AP

% dat_4AP = dlmread('Fig5B.csv');
dat_4AP = xlsread('Figure 5-Source Data1.xlsx',2);
% 11 columns:
% 1st is stimulus coherence (1st is standard loom)
% 2-6 are average spike counts for control responses (5 animals)
% 7-11 are average spike counts for responses after 4AP (same 5 animals)

N=5;
fh2 = figure; hold on
ah2 = gca;
ah2.Title.String = 'without standard loom';
ah2.YLabel.String = 'LGMD response (spks)';
ah2.XLabel.String = 'Stimulus coherence (%)';
for n=1:N
	linear_plotter( dat_4AP(2:end,1), dat_4AP(2:end,n+1), fh2,'k','none',[],0.5)
	linear_plotter( dat_4AP(2:end,1), dat_4AP(2:end,n+6), fh2,'b','none',[],0.5)
end
ah2.XLim = [-2,102];
ah2.YLim = [0,140];

ErrorBars( dat_4AP(2:end,1), nanmedian(dat_4AP(2:end,2:6),2), ...
	mad(dat_4AP(2:end,2:6),[],2), ah2, '.k', 'linear')
ErrorBars( dat_4AP(2:end,1), nanmedian(dat_4AP(2:end,7:11),2), ...
	mad(dat_4AP(2:end,7:11),[],2), ah2, '.b', 'linear')
ErrorBars( dat_4AP(1,1), nanmedian(dat_4AP(1,2:6),2), mad(dat_4AP(1,2:6),[],2), ah2, 'pk')
ErrorBars( dat_4AP(1,1), nanmedian(dat_4AP(1,7:11),2), mad(dat_4AP(1,7:11),[],2), ah2, 'pb')


%% Figure 5C
% LGMD normalized response to looming stimulus coherence before and after 4AP

% norm_4AP = dlmread('Fig5C.csv');
norm_4AP = xlsread('Figure 5-Source Data1.xlsx',3);
% 11 columns:
% 1st is stimulus coherence (1st is standard loom)
% 2-6 are average spike counts for control responses (5 animals)
% 7-11 are average spike counts for responses after 4AP (same 5 animals)

fh2 = figure; hold on
ah2 = gca;
ah2.Title.String = 'without standard loom';
ah2.YLabel.String = 'LGMD response (spks)';
ah2.XLabel.String = 'Stimulus coherence (%)';

ErrorBars( norm_4AP(2:end,1), nanmean(norm_4AP(2:end,2:6),2), ...
	nanstd(norm_4AP(2:end,2:6),[],2), ah2, '.k', 'linear')
ErrorBars( norm_4AP(2:end,1), nanmean(norm_4AP(2:end,7:11),2), ...
	nanstd(norm_4AP(2:end,7:11),[],2), ah2, '.b', 'linear')
scatter(ah2, 100, nanmean(norm_4AP(1,2:6),2), 80,'pk','filled')
scatter(ah2, 100, nanmean(norm_4AP(1,7:11),2), 80,'pb', 'filled')
ah2.XLim = [-2,102];
ah2.YLim = [0,200];

%% Figure 5D
% percent change after channel blockade relative to control (channels present)

% pct_chg = dlmread('Fig5D.csv');
pct_chg = xlsread('Figure 5-Source Data1.xlsx',4);

fh2 = figure; hold on
ah2 = gca;
ah2.YLabel.String = 'Change in response (%)';
ah2.XLabel.String = 'Stimulus coherence (%)';

ErrorBars( pct_chg(2:end,7), pct_chg(2:end,8), pct_chg(2:end,9), ah2, '.g', 'linear')
ErrorBars( pct_chg(2:end,1), pct_chg(2:end,2), pct_chg(2:end,3), ah2, '.r', 'linear')
ErrorBars( pct_chg(2:end,4), pct_chg(2:end,5), pct_chg(2:end,6), ah2, '.b', 'linear')

ErrorBars( pct_chg(1,7), pct_chg(1,8), pct_chg(1,9), ah2, 'pg')
ErrorBars( pct_chg(1,1), pct_chg(1,2), pct_chg(1,3), ah2, 'pr')
ErrorBars( pct_chg(1,4), pct_chg(1,5), pct_chg(1,6), ah2, 'pb')
ylim(ah2, [-70,120])
xlim(ah2, [-2,102])
