
%% Figure 5 - Supplement 1

% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

%% Figure 5-S1A
% LGMD responses to looming stimulus coherence control and with -2.5 nA dc

% dat_m25 = dlmread('Fig5-S1A.csv');
dat_m25 = xlsread('Figure 5-Source Data2.xlsx',1);
% 11 columns:
% 1st is stimulus coherence (1st is standard loom)
% 2-6 are average spike counts for control responses (5 animals)
% 7-11 are average spike counts for responses with -2.5 nA dc (same 5 animals)

N=5;
fh2 = figure; hold on
ah2 = gca;
ah2.YLabel.String = 'LGMD response (spks)';
ah2.XLabel.String = 'Stimulus coherence (%)';
for n=1:N
	linear_plotter( dat_m25(1:3,1), dat_m25(1:3,n+1), fh2,'k','none',[],0.5)
	linear_plotter( dat_m25(1:3,1), dat_m25(1:3,n+6), fh2,'g','none',[],0.5)
end
ah2.XLim = [-2,102];
ah2.YLim = [0,45];

ErrorBars( dat_m25(1:3,1), nanmean(dat_m25(1:3,2:6),2), ...
	mad(dat_m25(1:3,2:6),[],2), ah2, '.k', 'linear')
ErrorBars( dat_m25(1:3,1), nanmean(dat_m25(1:3,7:11),2), ...
	mad(dat_m25(1:3,7:11),[],2), ah2, '.g', 'linear')
scatter(ah2, dat_m25(4,1), nanmean(dat_m25(4,2:6),2), 60,'k','filled')
scatter(ah2, dat_m25(4,1), nanmean(dat_m25(4,7:11),2), 60,'g','filled')

%% Figure 5-S1B
% LGMD responses to looming stimulus coherence control and with -2.5 nA dc

% m25_pref = dlmread('Fig5-S1B.csv');
m25_pref = xlsread('Figure 5-Source Data2.xlsx',2);
% 2 columns:
% 1st is coherence preference for control
% 2nd is coherence pfreference with -2.5 nA dc (5 animals)

fh2 = figure; hold on
ah2 = gca;
line(ah2, repmat([1;2],1,N), m25_pref', 'Color', [0.5,0.5,0.5] )
ErrorBars( [1,2], median(m25_pref), mad(m25_pref), ah2, '.k', 'linear')

ah2.YLim = [-0.05,0.3];
ah2.XLim = [0.8,2.2];
ah2.XTick=[1 2];
ah2.XTickLabel = {'Control','-2.5 nA dc'};
ah2.YLabel.String = 'Coherence preference (spk/% coh)';

