% Figure 6 of Dewell & Gabbiani 2018
% A 4AP-sensitive K+ conductance reduces dendritic depolarization for 
% spatially incoherent inputs

% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

%% Figure 6B
% same as Fig 6 supplement 1 A

% ang_Vm1 = dlmread('Fig6B.csv');
ang_Vm1 = xlsread('Figure 6-Source Data1.xlsx',1);

fh = figure; hold on
ah = gca;
ah.YLabel.String = 'Mean membrane potential (mV)';
ah.XLabel.String = 'Mean angular distance ()';

linear_plotter(ang_Vm1(:,1),ang_Vm1(:,2),fh,'b','.',10);
linear_plotter(ang_Vm1(:,3),ang_Vm1(:,4),fh,'k','.',10);
ah.YLim = [-70,-55];
ah.XLim = [0,70];

%% Figure 6C
% LGMD normalized Vm by stimulus angular distance before and after 4AP

% norm_4AP = dlmread('Fig6C.csv');
norm_4AP = xlsread('Figure 6-Source Data1.xlsx',2);
% 4 columns (one row for each of 6 animals):
% 1st has y-intercepts of control fits
% 2nd has slopes for control fits
% 3-4 are intercepts and slopes after 4AP

N = size(norm_4AP,1);
fh = figure; hold on
ah = gca;
ah.YLabel.String = 'Normalized depolarization';
ah.XLabel.String = 'Normalized angular distance';

for n=1:N
	line([0,1], [norm_4AP(n,1),norm_4AP(n,1)+norm_4AP(n,2)], 'Color', 'k')
	line([0,1], [norm_4AP(n,3),norm_4AP(n,3)+norm_4AP(n,4)], 'Color', 'b')
end
ah.XLim = [0,1];
ah.YLim = [0.2,1.1];


%% Figure 6D
% Slopes of Vm vs stimulus angular distance before and after 4AP

% ang_slopes = dlmread('Fig6D.csv');
ang_slopes = xlsread('Figure 6-Source Data1.xlsx',3);
% 3 columns (one row for each of 6 animals):
% 1st has mean time relative to collision for each period
% 2nd has slopes for control fits
% 3rd has slopes after 4AP

fh = figure; hold on
ah = gca;
ah.YLabel.String = 'Slope of linear fit (mV/)';
ah.XLabel.String = 'Time to collision (s)';

linear_plotter(ang_slopes(:,1), ang_slopes(:,2), fh,'k')
linear_plotter(ang_slopes(:,1), ang_slopes(:,3), fh,'b')

ah.XLim = [-2.7,-0.2];

%% Figure 6D
% Differences in slopes of Vm vs stimulus angular distance before and after 4AP

% slope_diff = dlmread('Fig6E.csv');
slope_diff = xlsread('Figure 6-Source Data1.xlsx',4);
% 1 columns (one row for each of 6 animals):
% 1st has mean time relative to collision for each period
% 2nd has slopes for control fits
% 3rd has slopes after 4AP

fh = figure; hold on
ah = gca;
ah.YLabel.String = 'Change in depolarization slope (mV/)';

scatter(ones(size(slope_diff)), slope_diff,60,'k','filled')

ah.YLim = [-3,0];
ah.XLim = [1,1.01];
