% Figure 6 - supplement 1 of Dewell & Gabbiani 2018
% A 4AP-sensitive K+ conductance reduces dendritic depolarization for 
% spatially incoherent inputs

%% Figure 6S1

ang_Vm = dlmread('Figure 6-Source Data2.csv');
% 24 columns (6 time windows, 4 columns each)
% for each time period the 1st column is angular distance for 4AP, 2nd is Vm for
% 4AP, 3rd is distance for control, 4th is Vm for control

for n=1:6
	fh = figure; hold on
	ah = gca;
	ah.YLabel.String = 'Mean membrane potential (mV)';
	ah.XLabel.String = 'Mean angular distance ()';

	linear_plotter(ang_Vm(:,4*n-3),ang_Vm(:,4*n-2),fh,'b','.',10);
	linear_plotter(ang_Vm(:,4*n-1),ang_Vm(:,4*n),fh,'k','.',10);
	ah.YLim = [-70,-40];
    title(['time window ' num2str(n)]);
end
% ah.XLim = [0,70];
