% Figure 7 of Dewell & Gabbiani 2018
% An active biophysical model reproduces the preference for coherent synaptic inputs.

% *****
% importing large data files with xlsread is much slower than with csvread or
% dlmread. If the sheets of the xlsx file are separated into separate csv files
% then the dlmread lines can be used for faster import.
% *****

%% Figure 7A
% Passive dendrites LGMD model IFR and Vm for coherent and random synapses

% pas_sim = dlmread('Fig7A.csv');
pas_sim = xlsread('Figure 7-Source Data1.xlsx',1);
% 5 columns
% 1st is time vector
% 2-3 are simulated Vm for coherent loom and spatially random synapses
% 4-5 are simulated IFR for coherent loom and spatially random synapses

fh = figure; hold on
ah = gca;
ah.Title.String = 'Passive dendrite Model';
ah.YLabel.String = 'Simulated Vm (mV)';
ah.XLabel.String = 'Time relative to collision (s)';
plot( ah, pas_sim(:,1), pas_sim(:,3), 'Color', 'g','LineWidth',1)
plot( ah, pas_sim(:,1), pas_sim(:,2), 'Color', 'k','LineWidth',1)
ah.XLim = [-5,0];
ah.YLim = [-70,-25];

figure; hold on
ah = gca;
ah.Title.String = 'Passive dendrite Model';
ah.YLabel.String = 'Simulated IFR (spks/s)';
ah.XLabel.String = 'Time relative to collision (s)';
plot( ah, pas_sim(:,1), pas_sim(:,5), 'Color', 'g','LineWidth',2)
plot( ah, pas_sim(:,1), pas_sim(:,4), 'Color', 'k','LineWidth',2)
ah.XLim = [-5,0];
ah.YLim = [0,150];

%% Figure 7B
% Leak and HCN dendrites LGMD model IFR and Vm for coherent and random synapses

% hcn_sim = dlmread('Fig7B.csv');
hcn_sim = xlsread('Figure 7-Source Data1.xlsx',2);
% 5 columns
% 1st is time vector
% 2-3 are simulated Vm for coherent loom and spatially random synapses
% 4-5 are simulated IFR for coherent loom and spatially random synapses

fh = figure; hold on
ah = gca;
ah.Title.String = 'HCN only dendrite Model';
ah.YLabel.String = 'Simulated Vm (mV)';
ah.XLabel.String = 'Time relative to collision (s)';
plot( ah, hcn_sim(:,1), hcn_sim(:,3), 'Color', 'g','LineWidth',1)
plot( ah, hcn_sim(:,1), hcn_sim(:,2), 'Color', 'k','LineWidth',1)
ah.XLim = [-5,0];
ah.YLim = [-70,-25];

figure; hold on
ah = gca;
ah.Title.String = 'HCN only dendrite Model';
ah.YLabel.String = 'Simulated IFR (spks/s)';
ah.XLabel.String = 'Time relative to collision (s)';
plot( ah, hcn_sim(:,1), hcn_sim(:,5), 'Color', 'g','LineWidth',2)
plot( ah, hcn_sim(:,1), hcn_sim(:,4), 'Color', 'k','LineWidth',2)
ah.XLim = [-5,0];
ah.YLim = [0,150];

%% Figure 7C
% Passive LGMD model IFR and Vm for coherent and random synapses

% full_sim = dlmread('Fig7C.csv');
full_sim = xlsread('Figure 7-Source Data1.xlsx',3);
% 5 columns
% 1st is time vector
% 2-3 are simulated Vm for coherent loom and spatially random synapses
% 4-5 are simulated IFR for coherent loom and spatially random synapses

fh = figure; hold on
ah = gca;
ah.Title.String = 'Full LGMD Model';
ah.YLabel.String = 'Simulated Vm (mV)';
ah.XLabel.String = 'Time relative to collision (s)';
plot( ah, full_sim(:,1), full_sim(:,3), 'Color', 'g','LineWidth',1)
plot( ah, full_sim(:,1), full_sim(:,2), 'Color', 'k','LineWidth',1)
ah.XLim = [-5,0];
ah.YLim = [-70,-25];

figure; hold on
ah = gca;
ah.Title.String = 'Full LGMD Model';
ah.YLabel.String = 'Simulated IFR (spks/s)';
ah.XLabel.String = 'Time relative to collision (s)';
plot( ah, full_sim(:,1), full_sim(:,5), 'Color', 'g','LineWidth',2)
plot( ah, full_sim(:,1), full_sim(:,4), 'Color', 'k','LineWidth',2)
ah.XLim = [-5,0];
ah.YLim = [0,150];


%% Figure 7E
% model LGMD Vm at different dendritic locations

% sim_Vm = dlmread('Fig7E.csv');
sim_Vm = xlsread('Figure 7-Source Data1.xlsx',4);
% 13 columns
% 1st is time vector
% 2-7 are Vm at 6 dendritic compartments during simulated coherent loom
% 8-13 are Vm at 6 dendritic compartments during simulated incoherent loom

fh = figure; hold on
ah = gca;
ah.YLabel.String = 'Simulated Vm (mV)';
ah.XLabel.String = 'Time relative to collision (s)';
plot( ah, sim_Vm(:,1), sim_Vm(:,2), 'Color', 'r','LineWidth',1)
plot( ah, sim_Vm(:,1), sim_Vm(:,3), 'Color', 'g','LineWidth',1)
plot( ah, sim_Vm(:,1), sim_Vm(:,4), 'Color', 'm','LineWidth',1)
plot( ah, sim_Vm(:,1), sim_Vm(:,5), 'Color', [0.4,0.4,0.4],'LineWidth',1)
plot( ah, sim_Vm(:,1), sim_Vm(:,6), 'Color', 'b','LineWidth',1)
plot( ah, sim_Vm(:,1), sim_Vm(:,7), 'Color', 'y','LineWidth',1)
ah.XLim = [-5,0.1];
ah.YLim = [-67,-10];

figure; hold on
ah = gca;
ah.YLabel.String = 'Simulated Vm (mV)';
ah.XLabel.String = 'Time relative to collision (s)';
plot( ah, sim_Vm(:,1), sim_Vm(:,8), 'Color', 'r','LineWidth',1)
plot( ah, sim_Vm(:,1), sim_Vm(:,9), 'Color', 'g','LineWidth',1)
plot( ah, sim_Vm(:,1), sim_Vm(:,10), 'Color', 'm','LineWidth',1)
plot( ah, sim_Vm(:,1), sim_Vm(:,11), 'Color', [0.4,0.4,0.4],'LineWidth',1)
plot( ah, sim_Vm(:,1), sim_Vm(:,12), 'Color', 'b','LineWidth',1)
plot( ah, sim_Vm(:,1), sim_Vm(:,13), 'Color', 'y','LineWidth',1)
ah.XLim = [-5,0.1];
ah.YLim = [-67,-10];


%% Figure 7F
% h activation and KD inactivation in dendritic field A during loom

% gm_dat = dlmread('Fig7F.csv');
gm_dat = xlsread('Figure 7-Source Data1.xlsx',5);
% 5 columns
% 1st is time vector
% 2nd is gH for standard loom
% 3rd is gH for 0% coherence loom
% 4th is IKD inact for standard loom after HCN block
% 5th is IKD inact for standard loom control
% 6th is IKD inact for 0% coherence loom

figure; hold on
ah=gca;

figure; hold on
ah2=gca;

ah.YLabel.String = 'gH activation (%)';
ah2.YLabel.String = 'K+ inactivation (%)';
ah.XLabel.String = 'Time relative to collision (s)';
ah2.XLabel.String = 'Time relative to collision (s)';

plot(ah, gm_dat(:,1), gm_dat(:,2),'--k','LineWidth',1.5)
plot(ah, gm_dat(:,1), gm_dat(:,3),'LineStyle', '--','Color',[0.6,0.6,0.6],'LineWidth',1.5)

plot(ah2, gm_dat(:,1), gm_dat(:,5),'k','LineWidth',1.5)
plot(ah2, gm_dat(:,1), gm_dat(:,6),'Color',[0.6,0.6,0.6],'LineWidth',1.5)
plot(ah2, gm_dat(:,1), gm_dat(:,4),'r','LineWidth',1.5)

ah.YLim = [0,30];
ah.XLim = [-5,0.05];
ah2.YLim = [30,100];
ah2.XLim = [-5,0.05];


%% Figure 7G
% h and KD total membrane current in dendritic field A during loom

% Im_dat = dlmread('Fig7G.csv');
Im_dat = xlsread('Figure 7-Source Data1.xlsx',6);
% 5 columns
% 1st is time vector
% 2nd is Ih for standard loom
% 3rd is Ih for 0% coherence loom
% 4th is IKD for standard loom
% 5th is IKD for 0% coherence loom

figure;
ah = subplot(2,1,1); hold on
ah.XTick = [];
ah2 = subplot(2,1,2); hold on

ah.YLabel.String = 'IH (nA)';
ah.YDir = 'reverse';
ah2.YLabel.String = 'IKD-like (nA)';
ah2.XLabel.String = 'Time relative to collision (s)';

plot(ah, Im_dat(:,1), Im_dat(:,2),'k','LineWidth',1.5)
plot(ah, Im_dat(:,1), Im_dat(:,3),'Color',[0.6,0.6,0.6],'LineWidth',1.5)

plot(ah2, Im_dat(:,1), Im_dat(:,4),'k','LineWidth',1.5)
plot(ah2, Im_dat(:,1), Im_dat(:,5),'Color',[0.6,0.6,0.6],'LineWidth',1.5)

ah.YLim = [-2.4,0];
ah.XLim = [-5,0.1];
ah.XTick = -2.4:0.8:0;
ah2.YLim = [0,15];
ah2.XLim = [-5,0.1];

%% Figure 7I
% LGMD model KD and CaT inactivation

% inact = dlmread('Fig7I.csv');
inact = xlsread('Figure 7-Source Data1.xlsx',7);
% 3 columns
% 1st is coherence vector
% 2nd is KD inactivation
% 3rd is CaT inactivation


fh=figure; hold on
ah = gca;

ah.YLabel.String = 'Channel inactivation (%)';
ah.XLabel.String = 'Stimulus coherence (%)';

linear_plotter( inact(:,1), inact(:,2)*100, fh,'k')
linear_plotter( inact(:,1), inact(:,3)*100, fh,'g')

ah.YLim = [75,100];
ah.XLim = [-1,101];
