function ErrorBars(X, Y, E, h, symbol, varargin)
% 
% ErrorBars(X,Y,E,h,color)
% ErrorBars(Y,E,h,color)
% ErrorBars(X,Y,E,color)
% ErrorBars(Y,E,color)
% ErrorBars(Y,E)
% Y-values (Y) and errors (E) must be given as numeric vectors of equal
% length. If no X-values are given, 1:length(Y) is used by default. If no
% graphics handle (h) is given, a new figure is generated. Black is the
% default color.
% additional arguments include, 'parent', 'linear',


% Parse possible Axes input
narg = nargin - length(varargin);
if nargin < 2
	error('ErrorBars line18. Must give at least 2 argin.')
end
if nargin == 2,
	E = Y(:);
	Y = X(:);
	X = (1:length(Y))';
	figure;
	h = gca;
elseif all(ishghandle(E(:))) && ~all(E(:) == 0)  % Y, E, h
	if narg == 4	% Y, E, h, symbol
		symbol = h;
	end
	if ishghandle(E, 'axes')
		h = E;
	else
		figure(E)
		h = gca;
	end
	E = Y(:);
	Y = X(:);
	X = (1:length(Y))';
elseif nargin < 4
	figure;
	h = gca;
	if nargin == 3 && ischar(E), % Y, E || Y,E,symbol
		symbol = E;
		E = Y(:);
		Y = X(:);
		X = (1:length(Y))';
	end
elseif isempty(h) || ~isscalar(h) || ~ishghandle(h)
	if nargin == 4	% X, Y, E, symbol
		symbol = h;
		figure;
		h = gca;
	end
elseif ~isempty(varargin)
	h_id = find(strcmpi(varargin, 'parent'),1);
	if ~isempty(h_id)  && length(varargin) > h_id + 1 && ishghandle(varargin{h_id+1})
		h = varargin{h_id + 1};
		varargin(h_id:h_id+1) = [];
	elseif isempty(h) || ~ishghandle(h)
		h = axes;
	end
end

if strcmpi( get( h, 'Type'), 'figure' )
	figure(h);
	h = gca;
elseif ~strcmpi( get( h, 'Type'), 'axes' )
	error( 'Not a valid handle for plotting ErrorBars') 
end


if isequal(numel(X), numel(Y), numel(E))
	X = X(:); Y = Y(:); E = E(:);
end
if ~all( isvect( X,Y,E(:,1) ) ) || ~isequal(size(X,1),size(Y,1),size(E,1))
	error('Must specify Y and E vectors of equal length')
end

if ~exist('symbol', 'var') || isempty(symbol)
	col = 'k'; 	mark = 'o'; ls = 'none'; symbol = 'ko';
else
	[ls,col,mark,msg] = colstyle(symbol);
	error(msg)
	if isempty(ls),
		ls = 'none';
	end
end

% tee = (max(x(:))-min(x(:)))/100;  % make tee .02 x-distance for error bars
if (length(X) == 1)
	tee = 0.1;
else
	tee = median(diff(unique(X)))/10;		% make tee 20% of x interval
end
if (numel(unique(tee)) > 1)
	tee(end+1) = tee(end);
else
	tee = tee(1);
end

if size(E,2) == 1
	if any(strcmpi(varargin,'x'))
		xbar = true;
		xl = X - E;
		xr = X + E;
		ytop = Y + tee;
		ybot = Y - tee;
	else
		ybar = true;
		ytop = Y + E;
		ybot = Y - E;
		xl = X - tee;
		xr = X + tee;
	end
elseif size(E,2) == 2
	if any(strcmpi(varargin,'xy'))
		xl = X - E(:,1);
		xr = X + E(:,1);
		ybot = Y - E(:,2);
		ytop = Y + E(:,2);
	elseif any(strcmpi(varargin,'x'))
		xl = E(:,1);
		xr = E(:,2);
		ybot = Y - tee;
		ytop = Y + tee;
	else
		ytop = E(:,1);
		ybot = E(:,2);
		xl = X - tee;
		xr = X + tee;
	end
elseif size(E,2) == 4
	if any(strcmpi(varargin,'xy'))
		xl = E(:,1);
		xr = E(:,2);
		ybot = E(:,3);
		ytop = E(:,4);
	else
		error('unknown error size')
	end
end
% scatter(X, Y, 'Parent', h,  'CData', short2rgb(col), 'Marker', mark)
% if ~isempty(ls)
% 	line(X, Y, 'Parent', h,  'Color', col, 'LineStyle', ls)
% end
% scatter(X,Y, 'Parent', h,  'Color', col, 'Marker', mark, 'LineStyle', ls)
holdh = ishold(h);
if ~holdh
	hold( h , 'on' )
end
if any(strcmpi(varargin,'linear'))
	linear_plotter(X, Y, h.Parent, col, mark)
else
	plot(X,Y, symbol, 'Parent', h, 'LineStyle', ls, 'MarkerSize', 25)
end

if any(strcmpi(varargin,'xy'))
	line([X-tee, X+tee]', [ytop, ytop]', 'Parent', h, 'Color', col)
	line([X-tee, X+tee]', [ybot, ybot]', 'Parent', h, 'Color', col)
	line([X, X]', [ybot, ytop]', 'Parent', h, 'Color', col)
	tee = min(diff(sort(unique(Y))))/10;
	line([xl, xl]', [Y - tee, Y + tee]', 'Parent', h, 'Color', col)
	line([xr, xr]', [Y - tee, Y+ tee]', 'Parent', h, 'Color', col)
	line([xl,xr]', [Y, Y]', 'Parent', h, 'Color', col)
else
	line([xl, xr]', [ytop, ytop]', 'Parent', h, 'Color', col)
	line([xl, xr]', [ybot, ybot]', 'Parent', h, 'Color', col)
	line([X, X]', [ybot, ytop]', 'Parent', h, 'Color', col)
end

if ~holdh
	hold( h , 'off' )
end


