function ErrorPlot (xdata, mean_y, std_y, axis_h, smooth, color)
%
% ErrorPlot (xdata, mean_y, std_y, axis_h, smooth, color)
%
% ErrorPlot plots the mean response as a solid curve, with shaded area of
% plus and minus 1 std. Requires inputs of xdata, mean response, and std
% vectors of equal length. If no axis handle is given, a new figure window
% is created. Line and shading color is optional.

if ~all( size(mean_y) == size(std_y) )
	error('mean and std must be same size')
elseif	~any( size(mean_y) == size(xdata) )
	error('time and data must be same size')
end

dim = find( size(mean_y) == size(xdata) );
if nargin<4 || isempty(axis_h),
	figure;
	axis_h = gca;
end

if nargin<6 || isempty(color),
	co = axis_h.ColorOrder;
	coi = axis_h.ColorOrderIndex;
% 	color = 'g';
else
	coi = 1;
	co = color;
end

sn = 10;	% decimate data 10 fold for patch
if nargin<5 || isempty(smooth),
	smooth = true;          % default is to decimate data before plotting patch
elseif (smooth>1)
	sn = smooth;
	smooth = true;
end

[rows, cols] = size(xdata);
if cols>rows && ~isequal(dim,1),	% time should be a single column
	xdata = xdata';
	mean_y = mean_y';
	std_y = std_y';
end

nvect = size(mean_y,2);
nt = size(xdata,2);
if nt > 1 && nt ~= nvect
	error('must have either single x vector, or x matrix of same size as data')
end

for n = 1:nvect
	
	colr = co(mod(coi-1,size(co,1))+1,:);
	coi = coi+1;
% 	std_y(1,n) = 0;
	area_top = [mean_y(1,n); mean_y(:,n) + std_y(:,n)];
	area_bottom = [mean_y(1,n); mean_y(:,n) - std_y(:,n)];
	if nt > 1
		t = xdata(:,n);
	else
		t = xdata;
	end
	if smooth && length(xdata) > sn
		% area = decimate([area_top; area_bottom(end:-1:1)], 10);
		% areatime = downsample([xdata; xdata(end:-1:1)], 10);
		% double_time = [xdata; xdata(end:-1:1)];
		% areatime = double_time(1:10:end);
		
		ts = t(1:sn:end);
		areatime = [ts; ts(end:-1:1)];
		shorten = interp1(t, [area_top(2:end), area_bottom(2:end)], ts, 'linear');
		% area = interp1(double_time, [area_top; area_bottom(end:-1:1)], areatime, 'linear');
		area = [shorten(:,1); shorten(end:-1:1,2)];
	else
		area = [area_top; area_bottom(end:-1:1)];
		areatime = [t(1); t; t(end:-1:1); t(1)];
	end
	% tic;
	% fill(areatime, area, color, 'Parent', axis_h, 'FaceAlpha', 0.25, 'LineStyle', 'none')
	% toc
	% tic;
	if ~isequal( area_top, area_bottom )
		patch(areatime, area, colr, 'Parent', axis_h, 'FaceAlpha', 0.25, 'LineStyle', 'none')
	end
	% toc
	
	line('Parent', axis_h, 'XData', t, 'YData', mean_y(:,n), 'Color', colr, ...
		'Linewidth', 2)
	
end
