function [b, a, y_p] = lin_Fit( x_var, y_var, sigma_v)
% function [b, a, y_p] = lin_Fit( x_var, y_var, sigma_v)
% 
% linear fit by minimizing chi square according to NR in C, sect. 15-2.

narginchk(2,3)
if size(x_var) ~= size(y_var)
	if size(x_var) == size(y_var')
		x_var = x_var';
	else
		errordlg('variables must be the same length')
		return
	end
end

nans = isnan(x_var) | isnan(y_var);
x_var(nans) = [];
y_var(nans) = [];

if nargin == 2
	sigma_v = ones(size(x_var));
end
% if nargin == 3,
	S = sum( 1./sigma_v.^2 );
	S_x = sum( x_var./sigma_v.^2 );
	S_y = sum( y_var./sigma_v.^2 );
	t_v = (1./sigma_v).*(x_var-S_x/S);
	S_tt = sum( t_v.^2 );

	b = (1./S_tt).*sum( (t_v.*y_var)./sigma_v );
	a = (S_y - S_x.*b)./S;
% 	siga = sqrt( (1 + S_x^2/(S*S_tt))/S );	% variance of a
% 	sigb = sqrt(1/S_tt);					% variance of b
% else
% 	Sx = sum(x_var);
% 	Sy = sum(y_var);
% 	ss = length(x_var);
% 	mean_x = Sx/ss;		% mean
% 	t = x_var - mean_x;
% 	% st2 = sum(t.^2);
% 	% b2 = sum(t.*y_var);
% 	% b2 = b2/st2;
% 	b = sum(t.*yvar)/sum(t.^2);
% 	a = ( Sy - Sx*b ) / ss ;
% end

if nargout > 2
	y_p = b*x_var+a;
	
	if any(nans)
		tmp(~nans) = y_p;
		tmp(nans) = nan;
		y_p = tmp;
	end
end

% t = x_var-mean(x_var);
% Stt = sum(t.^2);
% b = sum( (t.*y_var) ) / sum( t.*t );
% a = (Sy - Sx*b)/length(x_var);

% siga = ;	% variance of a
% sigb = ;	% variance of b
% q = ;		% goodness of fit
% chi2 = ;	% chi-square


% 
% chi2 = sum( (y_var - a - b * x_var).^2 );
% sigdat = sqrt( chi2 / (ss - 2) );
