function [fig_h,b,a,r,p] = linear_plotter( xvar, yvar, fig_h, color, symbol, marksize, lwid)
% [fig_h,b,a,r,p] = linear_plotter( xvar, yvar, fig_h, color, symbol, marksize, lwid))
% if color is 'multi', a different color is used for each column of data

% x_max = max( xvar );
% x_min = min( xvar );
if nargin < 3 || isempty(fig_h) || ~ishghandle(fig_h)
    fig_h = figure;
 	ah = gca;
elseif ishghandle(fig_h, 'axes')
	ah = fig_h;
	fig_h = ah.Parent;
else
	figure(fig_h)
 	ah = gca;
end

if nargin<4 || isempty(color)
    color = 'k';
end
if nargin<5 || isempty(symbol)
    symbol = '.';
end
if nargin<6 || isempty(marksize)
    marksize = 28;
end
if nargin<7 || isempty(lwid)
    lwid = 1.5;
end

xs = size(xvar);
ys = size(yvar);
if (sum(xs)~=sum(ys))
	error('linear_plotter: Data must be the same size')
end

if any(xs~=ys)
	for n=1:numel(xs)
		if all(xs==circshift(ys,n,2))
			yvar = shiftdim(yvar,n);
			break
		end
	end
end
if ~all(size(xvar)==size(yvar))
	error('linear_plotter: Data must be the same size')
end

% nans = isnan(xvar) | isnan(yvar);
% xvar(nans) = [];
% yvar(nans) = [];

[b,a]  = lin_Fit( xvar(:), yvar(:) );
if nargout > 3
	[r,p] = corr( xvar(:), yvar(:), 'rows', 'complete' );
end

figure(fig_h)
% hold on
if ~strcmp(symbol, 'none')
	if strcmpi('multi',color)
		plot( ah, xvar, yvar, symbol, 'MarkerSize', marksize)
	else
		plot( ah, xvar, yvar, symbol, 'Color', color, 'MarkerSize', marksize)
	end
end
% scatter( gca, xvar, yvar, [], color, 'filled')
xends = [min(xvar(:)),max(xvar(:))];
fends = b.*xends+a;
if strcmpi('multi',color)
	line( xends, fends, 'Parent', ah, 'Color', 'k', 'LineWidth', lwid)
else
	line( xends, fends, 'Parent', ah, 'Color', color, 'LineWidth', lwid)
% 	line( xvar(~isnan(xvar)), fit, 'Color', color)
end
% line( [x_min, x_max], [ x_min*b(2)+b(1), x_max*b(2)+b(1)])

if nargout==0
	clear fig_h
end

end