

function [mu1,mu2] = genChemControlFunctions(muAmp1,muAmp2,pulses,...
    mudel1,mudel2,muOn1,muOn2,muOff1,muOff2,Nt,tmax)

dt = tmax/Nt;
ndelay1 = ceil(mudel1/dt)+1;
ndelay2 = ceil(mudel2/dt)+1;

if pulses == 1
    mu1 = zeros(1,Nt);
    mu2 = zeros(1,Nt);

    % === CHEMICAL 1 ===
    non1 = ceil(muOn1/dt);
    noff1 = ceil(muOff1/dt);
    npulse1 = non1+noff1; % fill width

    k1 = 0;
    j1 = 0;
    for ti = ndelay1:1:Nt
        if k1 < non1 
            mu1(ti) = muAmp1;
            k1 = k1 + 1;
        else
            j1 = j1 + 1;
        end
        if k1 + j1 >= npulse1
            k1 = 0;
            j1 = 0;
        end % reset
    end % END C1
    
        % === CHEMICAL 1 ===
    non2 = ceil(muOn2/dt);
    noff2 = ceil(muOff2/dt);
    npulse2 = non2+noff2; % fill width

    k2 = 0;
    j2 = 0;
    for ti = ndelay2:1:Nt
        if k2 < non2 
            mu2(ti) = muAmp2;
            k2 = k2 + 1;
        else
            j2 = j2 + 1;
        end
        if k2 + j2 >= npulse2
            k2 = 0;
            j2 = 0;
        end % reset
    end % END C2
    
else
    mu1 = muAmp1*ones(1,Nt);
    mu2 = muAmp2*ones(1,Nt);
    mu1(1:ndelay1) = 0;
    mu2(1:ndelay2) = 0;
end


end