

function outdata = simulatorContinuous(xmin,xmax,xbnd,Nx,...
    ymin,ymax,ybnd,Ny,tmax,dt,...
    db,d1,d2,s1,s2,a1,a2,b1,k1,k2,l1,l2,...
    Nb,numGrps,aligngrps,sticky,...
    perturbationType,noiseAmp,kval,repDelay,...
    muAmp1,muAmp2,pulses,mudel1,mudel2,muOn1,muOn2,muOff1,muOff2,...
    velDelay,vmax,rotation,vrad,veltype,...
    saveRate,graphics,framePeriod,saveVid,vidName,vidType)
%------------------------------------------------------------------------
%------------------------------------------------------------------------

% ===== INITIALIZE VARIABLES =====
rng('shuffle'); % seed random number generator

% === DISCRETIZE SPACE ===
dx = (xmax - xmin)/Nx;
dy = (ymax - ymin)/Ny;
x = (xmin-dx):dx:(xmax+dx); % including ghost nodes x(1) and x(Nx+3)
y = (ymin-dx):dy:(ymax+dx); % including ghost nodes y(1) and y(Ny+3)

Nt = ceil(tmax/dt); % number of timesteps
t = 0; % initialize time

% === SAVE VARIABLES ===
nsave = ceil(Nt/saveRate);
dataRec = zeros(nsave,3,Nx+3,Ny+3);
svi = 0; % save index

% === GENERATE VELOCITY FIELD ===
[velX,velY] = genVelocity(veltype,vmax,rotation,vrad,x,y); 

% === INITIALIZE FIELDS ===
[bacteria,c1,c2] = constructContinuousFields(Nx,Ny,s1,s2,...
    a1,a2,b1,k1,k2,l1,l2,Nb,numGrps,aligngrps,...
    perturbationType,noiseAmp,kval,x,y);

% === CHEMICAL CONTROL FUNCTIONS ===
[mu1,mu2] = genChemControlFunctions(muAmp1,muAmp2,pulses,...
    mudel1,mudel2,muOn1,muOn2,muOff1,muOff2,Nt,tmax);

% === GRAPHICS ===
if saveVid == 1 && graphics == 1
    if vidType == 2
        vid = VideoWriter(vidName,'Uncompressed AVI');
    else
        vid = VideoWriter(vidName,'MPEG-4');
    end
    open(vid);
end

% figure window for graphics
if graphics == 1
    scrsz = get(groot,'ScreenSize');
    % scrsz = [1 1 width height]
    % position: [left bottom width height]
    h = figure('Position',[scrsz(3)/4 scrsz(4)/4 scrsz(3)/2 scrsz(4)/2]);
end



%-------------------------------------------------------------------------
%-------------------------------------------------------------------------
% ===== LOOP THROUGH TIME =====
for ti = 1:Nt

    % apply boundary conditions:
    [bacteria,c1, c2] = updateGhosts2(bacteria,c1,c2,Nx,Ny,xbnd,ybnd);
    
    % === BACTERIA DYNAMICS ===
    cp1 = bacteria*s1;
    cp2 = bacteria*s2;

    bdiff = db*laplacian(dx,dy,bacteria);
    if veltype <= 0 || vmax == 0 || t < velDelay || sticky == 1
       badv = 0;
    else
       badv = chemAdvect(dx,dy,velX,velY,bacteria);
    end

    fitness = (t > repDelay)*fitnessField(a1,a2,b1,s1,k1,k2,c1,c2);

    bacteria = bacteria + (bdiff + badv + bacteria.*fitness)*dt;
    
    % === CHEMICAL 1 DYNAMICS ===
    cppdiff1 = d1*laplacian(dx,dy,c1);
    if veltype <= 0 || vmax == 0 || t < velDelay
       cppadv1 = 0;
    else
       cppadv1 = chemAdvect(dx,dy,velX,velY,c2);
    end
    c1 = c1 + (cp1 + cppdiff1 + cppadv1 - l1*c1 + mu1(ti))*dt;
    
    % === CHEMICAL 2 DYNAMICS ===
    cppdiff2 = d2*laplacian(dx,dy,c2);
    if veltype <= 0 || vmax == 0 || t < velDelay
       cppadv2 = 0;
    else
       cppadv2 = chemAdvect(dx,dy,velX,velY,c2);
    end
    c2 = c2 + (cp2 + cppdiff2 + cppadv2 - l2*c2 + mu2(ti))*dt;
    
    % update time:
    t = t + dt;
    
    % === SAVE DATA ===
    if mod(ti,saveRate) == 0
        svi = svi + 1;
        dataRec(svi,1,:,:) = bacteria;
        dataRec(svi,2,:,:) = c1;
        dataRec(svi,3,:,:) = c2; 
    end

    % display:
    if graphics == 1 && mod(ti-1,framePeriod) == 0
        F = displayGraphics2(xmin,xmax,Nx,ymin,ymax,Ny,...
            bacteria,c1,c2,t,h);
    end
    
    % video:
    if graphics == 1 && saveVid == 1
        if mod(ti,saveRate) == 1;
            %F = getframe(gcf);
            writeVideo(vid,F);
        end
    end
end % end time loop
%--------------------------------------------------------------------
%--------------------------------------------------------------------

% close video file:
if saveVid == 1
    close(vid);
end

% out put save variable:
outdata = dataRec;

end % END OF FUNCTION





