

% FIGURE 6 PLOTS (HAGEN-POISEUILLE AND RANKINE VORTEX FLOW)
close all; clear; clc;

%=======================================================================
% (C & E) HAGEN-POISEUILLE POPULATION AND SECRETION RATE

load('pipe_flow_data.mat');

% FILE DATA:
% hpRad: x axis of plots, pipe radial distance
% popDensity: population density as function of distance from pipe center, r
% secAve: average secretion rate as function of distance from pipe center, r
% shear: shear rate as function of distance from pipe, r

Rad = 25;
Len = 50;
scale = 0.0001;

% POPULATION:
figure;
ax = axes;
%yyaxis left;
plot(hpRad,popDensity,'linewidth',3);
ylim([0 6.7]);
ylabel('Population density (mm^{-2})');
xlabel('Distance from pipe center, r (mm)'); %,'FontSize',18);

figure;
%yyaxis right;
plot(sRad,scale*shear,'linewidth',3);
ylabel('Shear rate (s^{-1})');
ylim([0 scale*(4.0+2.5)]);
sft = -1;
xlabel('Distance from pipe center, r (mm)'); %,'FontSize',18);
xlim([-Rad-sft Rad+sft]);
set(ax,'linewidth',2);
set(gca,'fontsize',24);

% save:
fig = gcf;
svfl = 'lam_flow_pop';
%fig.PaperPositionMode = 'auto';
print(svfl,'-dpng','-r0');


% SECRETION:
sscl = 1/100;

figure;
ax = axes;
%yyaxis left;
plot(hpRad,sscl*secAve,'linewidth',3);
ylim([0 sscl*55]);
ylabel('Average secretion rate (s^{-1})');
xlabel('Distance from pipe center, r (mm)'); %,'FontSize',18);

figure;
%yyaxis right;
plot(sRad,scale*shear,'linewidth',3);
ylabel('Shear rate (s^{-1})');
ylim([0 scale*(4.0+2.5)]);
sft = -1;
xlabel('Distance from pipe center, r (mm)'); %,'FontSize',18);
xlim([-Rad-sft Rad+sft]);
set(ax,'linewidth',2);
set(gca,'fontsize',24);

% save:
fig = gcf;
svfl = 'lam_flow_sec';
%fig.PaperPositionMode = 'auto';
print(svfl,'-dpng','-r0');


%=======================================================================
% (D & F) RANKINE VORTEX POPULATION AND SECRETION RATE

clear; clc;
load('vortex_flow_data.mat');

% FILE DATA:
% vrad: x axis of plots, vortex radial distance
% popDensity: population density as function of distance from vortex center, r
% secAve: average secretion rate as function of distance from vortex center, r
% shear: shear rate as function of distance from vortex, r


Rad = 50;
scale = 0.0001;

% POPULATION:
figure;
ax = axes;
%yyaxis left;
plot(vrad,popDensity,'linewidth',3);
ylim([0 1.1]);
ylabel('Population density (mm^{-2})');
xlabel('Distance from vortex center, r (mm)'); %,'FontSize',18);

figure;
%yyaxis right;
plot(sRad,scale*shear,'linewidth',3);
ylabel('Shear rate (s^{-1})');
ylim([0 scale*(0.7799+0.1)]);
sft = -1;
xlabel('Distance from vortex center, r (mm)'); %,'FontSize',18);
xlim([-0-sft 50+sft]);
set(ax,'linewidth',2);
set(gca,'fontsize',24);

% save:
fig = gcf;
svfl = 'vort_flow_pop';
%fig.PaperPositionMode = 'auto';
print(svfl,'-dpng','-r0');


% SECRETION:
sscl = 1/100;

figure;
ax = axes;
%yyaxis left;
plot(vrad,sscl*secAve,'linewidth',3);
ylim([0 sscl*55]);
ylabel('Average secretion rate (s^{-1})');
xlabel('Distance from vortex center, r (mm)'); %,'FontSize',18);

figure;
%yyaxis right;
plot(sRad,scale*shear,'linewidth',3);
ylabel('Shear rate (s^{-1})');
ylim([0 scale*(0.7799+0.1)]);
sft = -1;
xlabel('Distance from vortex center, r (mm)'); %,'FontSize',18);
xlim([-0-sft 50+sft]);
set(ax,'linewidth',2);
set(gca,'fontsize',24);

% save:
fig = gcf;
svfl = 'vort_flow_sec';
%fig.PaperPositionMode = 'auto';
print(svfl,'-dpng','-r0');
