

function [bacteria,c1,c2] = constructContinuousFields(Nx,Ny,s1,s2,...
    a1,a2,b1,k1,k2,l1,l2,Nb,numGrps,aligngrps,...
    perturbationType,noiseAmp,kval,x,y)

[X,Y] = meshgrid(x,y);
[nss,css1,css2] = findSteadyStates(s1,s2,l1,l2,a1,a2,b1,k1,k2);
bamp = 0.1*nss;
camp1 = 0.1*css1;
camp2 = 0.1*css2;


% PERTURBATIONS:
% 0: uniform if 0 groups, or groups
% 1: striped perturbation with wave number given by kval
% 2: square perturbation with wave number given by kval
% 3: hexagon perturbation with wave number given by kval
% 4: steady state plus noise given by noiseAmp times steady state value

if perturbationType == 0
    if numGrps <= 0
        bacteria = nss*ones(Nx+3,Ny+3);
        c1 = css1*ones(Nx+3,Ny+3);
        c2 = css2*ones(Nx+3,Ny+3);
    else
            if aligngrps == 1
                bacteria = zeros(Nx+3,Ny+3); % including ghost nodes
                npg = Nb/numGrps;
                yp = round(0.5*Ny)*ones(numGrps);
                if numGrps == 1
                    xp = round(0.5*Nx); % center singleton group
                else
                    tmpspacing = ceil(linspace(1,Nx,numGrps+1));
                    xp = transpose(tmpspacing(1:numGrps));
                end
                for i = 1:numGrps
                    bacteria(xp(i),yp(i)) = npg;
                end
                c1 = zeros(Nx+3,Ny+3);
                c2 = zeros(Nx+3,Ny+3);
           else
                bacteria = zeros(Nx+3,Ny+3); % including ghost nodes
                npg = Nb/numGrps;
                xp = randi([2 Nx+2],1,numGrps);
                yp = randi([2 Nx+2],1,numGrps);
                for i = 1:numGrps
                    bacteria(xp(i),yp(i)) = npg;
                end
                c1 = zeros(Nx+3,Ny+3);
                c2 = zeros(Nx+3,Ny+3);
            end % if aligning groups
    end % if groups or homogeneous
elseif perturbationType == 1
    % STRIPE PLANFORM
    stripefun = cos(kval*X);
    
    bacteria = bamp*stripefun + nss;
    c1 = camp1*stripefun + css1;
    c2 = camp2*stripefun + css2;
    
elseif perturbationType == 2
    % SQUARE PLANFORM
    squarefun = cos(kval*X).*cos(kval*Y);
    
    bacteria = bamp*squarefun + nss;
    c1 = camp1*squarefun + css1;
    c2 = camp2*squarefun + css2;
    
elseif perturbationType == 3
    % HEXAGON PLANFORMS
    hexfun1 = cos(kval*X);
    hexfun2 = cos(kval*(-(1/2)*X + (sqrt(3)/2)*Y));
    hexfun3 = cos(kval*(-(1/2)*X - (sqrt(3)/2)*Y));

    hexfuntotal = hexfun1 + hexfun2 + hexfun3;
    
    bacteria = bamp*hexfuntotal + nss;
    c1 = camp1*hexfuntotal + css1;
    c2 = camp2*hexfuntotal + css2;
    
elseif perturbationType == 4
    bacteria = noiseAmp*nss*rand(Nx+3,Ny+3) + nss;
    c1 = noiseAmp*css1*rand(Nx+3,Ny+3) + css1;
    c2 = noiseAmp*css2*rand(Nx+3,Ny+3) + css2;
else
    % default -- just do noise
    bacteria = rand(Nx+3,Ny+3);
    c1 = rand(Nx+3,Ny+3);
    c2 = rand(Nx+3,Ny+3);
end

% END OF FUNCTION
end
%---------------------------------------------------------------------


