


function F = displayGraphics2(xmin,xmax,Nx,ymin,ymax,Ny,...
    bacteria,c1,c2,t,h)

    dx = (xmax - xmin)/Nx;
    dy = (ymax - ymin)/Ny;
    x = xmin:dx:xmax;
    y = ymin:dy:ymax; 
    
    cscl1 = 1.5/max(max(c1));
    cscl2 = 1.5/max(max(c2));
    cscale = 1.5/max(max(bacteria));
    
    Clrs = zeros(Ny+1,Nx+1,3);
    for xi = 2:Nx+2
        for yi = 2:Ny+2
            Clrs(yi-1,xi-1,:) = [cscl1 0 0]*c1(xi,yi) ...
                + [0 0 cscl2]*c2(xi,yi) + ...
             [-cscl1 cscale -cscl2]*bacteria(xi,yi);
        end
    end    
    
    figure(h);
    image(x,y,Clrs);
    set(gca,'YDir','normal');
    shading interp;

    axis([xmin xmax ymin ymax]);
    title(sprintf('time = %1.8f',t)); 
    pause(0.001);
    hold off;

F = getframe(gcf);

end
