

function [nss,css1,css2] = findSteadyStates(sec1,sec2,lam1,lam2,...
    alp1,alp2,beta,sat1,sat2)


    gamma1 = sec1/(lam1*sat1);
    gamma2 = sec2/(lam2*sat2);
    a = (alp1 - alp2 - beta*sec1)*gamma1*gamma2;
    b = (alp1 - beta*sec1)*gamma1 - (alp2 + beta*sec1)*gamma2;
    c = -beta*sec1;
    
    np = (-b + sqrt( (b^2) - 4*a*c ) )/(2*a);
    nm = (-b - sqrt( (b^2) - 4*a*c ) )/(2*a);
    nss = max(np,nm);
    css1 = nss*gamma1*sat1;
    css2 = nss*gamma2*sat2;


end
