% --------------------------------------------------------------
% MAIN SCRIPT
% AUTHOR: GURDIP S. UPPAL
% DATE: 4/20/17
% --------------------------------------------------------------
% === CLEAR WORKSPACE ===
close all; clear; clc;
% TIME SIMULATION:
tic; % start stopwatch
%----------------------------------------------------------------
%----------------------------------------------------------------

% ===== USER DEFINED PARAMETERS =====

% === SPACE-TIME PARAMETERS ===
% SPACE:
xmin = -15;
xmax = 15;
ymin = -15;
ymax = 15;

% BOUNDARY CONDITIONS:
% (0 == periodic --- 1 == no flux)
xbnd = 0;
ybnd = 0;

% TIME:
tmax = 2.0;

% === SYSTEM PARAMETERS ===
% diffusion:
db = 0.3906;       % bacteria diffusion 
d1 = 5;         % resource diffusion contant
d2 = 15;        % waste diffusion constant
% fitness:
a1 = 75;        % resource benefit
a2 = 80;        % waste harm
b1 = 0.2;       % resource secretion cost
k1 = 0.01;      % resource saturation constant
k2 = 0.1;       % waste saturation constant
% chemicals:
s1 = 92;       % initial resource secretion (subject to mutations)
s2 = 91;       % waste secretion rate
l1 = 50;        % resource decay rate
l2 = 15;        % waste decay rate


% === FLOW VELOCITY PARAMETERS ===
% veltype options:
% 1 = Couette
% 2 = Hagen - Poisuille
% 3 = Rankine Vortex
% 4 = Constant (useful for sticky bacteria)
% else: no flow 
veltype = 0;
vmax = 0;           % maximum velocity for flow types 1,2, and 4
rotation = 0;       % vortex rotation rate \Gamma for flow type 3
vrad = 0;           % vortex radius R for flow type 3

% === CHEMICAL CONTROL FUNCTIONS ===
% amplitude:
mu1 = 0.0;      % amplitude of externally added chemical signal for public good (set to 0 for no intervention)
mu2 = 0.0;      % amplitude of externally added chemical signal for toxin (set to 0 for no intervention)
% pulses    (1 == pulsed, 0 == constant)
pulses = 0;
% delays:
mudel1 = 0.0;
mudel2 = 0.0;
% on period:
muOn1 = 0.00;
muOn2 = 0.00; 
% off period:
muOff1 = 0.0;
muOff2 = 0.0; 



% === BACTERIA INITIALIZATION ===
Nb = 100/25; 
initialNumGroups = 5;
aligngroups = 0;
sticky = 0;

perturbationType = 0;
% 0: uniform if 0 groups, or groups
% 1: striped perturbation with wave number given by kval
% 2: square perturbation with wave number given by kval
% 3: hexagon perturbation with wave number given by kval
% 4: steady state plus noise given by noiseAmp times steady state value
noiseAmp = 0; 
kval = 0;


% === SAVING AND VISUALIZATION ===
savePeriod = 100; 
% saves after this many time steps
savefile = sprintf('continuous_test'); 
% file name for data and video output
graphics = 1;
framePeriod = 100; % after how many time steps to display data
saveVideo = 0;
% options to visualize in real time and to save video (1 == true)



%-----------------------------------------------------------------------
%-----------------------------------------------------------------------
% ===== DERIVED AND RESERVED PARAMETERS =====
% (normally don't change these)

% === DISCRETIZATION ===
Nx = round((xmax-xmin)*5);    % x nodes - 1, dx = 0.2 
Ny = round((ymax-ymin)*5);    % y nodes - 1, dy = 0.2 
dt = 0.0001;

% === DELAYS ===
veldelay = 0;       % delay time for flow 
repdelay = 0;       % delay for reproduction

% === SAVE PARAMETERS ===
datechar = datestr(now,'mm-dd-yy_HH-MM-SS');
dataFile = sprintf('%s_%s_data.mat',savefile,datechar);
vidType = 1; %(2 == avi, else mp4)
vidFile = sprintf('%s_%s_vid',savefile,datechar);


%-----------------------------------------------------------------------
%-----------------------------------------------------------------------
% ===== RUN =====
data = simulatorContinuous(xmin,xmax,xbnd,Nx,ymin,ymax,ybnd,Ny,tmax,dt,...
    db,d1,d2,s1,s2,a1,a2,b1,k1,k2,l1,l2,...
    Nb,initialNumGroups,aligngroups,sticky,...
    perturbationType,noiseAmp,kval,repdelay,...
    mu1,mu2,pulses,mudel1,mudel2,muOn1,muOn2,muOff1,muOff2,...
    veldelay,vmax,rotation,vrad,veltype,...
    savePeriod,graphics,framePeriod,saveVideo,vidFile,vidType);

parsave(dataFile,data);

rntime = toc;
fprintf('\nProgram run time: %f \n',rntime);




