

function   [bact, c1, c2] = updateGhosts2(bact,c1,c2,Nx,Ny,xbnd,ybnd)

    % x boundary conditions:
    if xbnd == 0
        % periodic:
        bact(1,:) = bact(Nx+2,:); 
        bact(Nx+3,:) = bact(2,:); 
        c1(1,:) = c1(Nx+2,:); 
        c1(Nx+3,:) = c1(2,:); 
        c2(1,:) = c2(Nx+2,:); 
        c2(Nx+3,:) = c2(2,:); 
    elseif xbnd == 1
        % no flux:
        bact(1,:) = bact(2,:); 
        bact(Nx+3,:) = bact(Nx+2,:); 
        c1(1,:) = c1(2,:); 
        c1(Nx+3,:) = c1(Nx+2,:); 
        c2(1,:) = c2(2,:); 
        c2(Nx+3,:) = c2(Nx+2,:); 
    else
        % periodic (default):
        bact(1,:) = bact(Nx+2,:); 
        bact(Nx+3,:) = bact(2,:); 
        c1(1,:) = c1(Nx+2,:); 
        c1(Nx+3,:) = c1(2,:); 
        c2(1,:) = c2(Nx+2,:); 
        c2(Nx+3,:) = c2(2,:); 
    end % x boundary conditions
    
    % y boundary conditions:
    if ybnd == 0
        % periodic:
        bact(:,1) = bact(:,Ny+2); 
        bact(:,Ny+3) = bact(:,2); 
        c1(:,1) = c1(:,Ny+2); 
        c1(:,Ny+3) = c1(:,2); 
        c2(:,1) = c2(:,Ny+2); 
        c2(:,Ny+3) = c2(:,2); 
    elseif ybnd == 1
        % no flux:
        bact(:,1) = bact(:,2); 
        bact(:,Ny+3) = bact(:,Ny+2); 
        c1(:,1) = c1(:,2); 
        c1(:,Ny+3) = c1(:,Ny+2); 
        c2(:,1) = c2(:,2); 
        c2(:,Ny+3) = c2(:,Ny+2); 
    else 
        % no flux (default)
        bact(:,1) = bact(:,2); 
        bact(:,Ny+3) = bact(:,Ny+2); 
        c1(:,1) = c1(:,2); 
        c1(:,Ny+3) = c1(:,Ny+2); 
        c2(:,1) = c2(:,2); 
        c2(:,Ny+3) = c2(:,Ny+2); 
    end % y boundary conditions
end

