
% ===== PLOTS FOR FIGURE 5 =====
close all; clear; clc;


%===================================================================
% (A) GROUP REPRODUCTION RATE PLOT:
load('group_reproduction_data.mat');

% DATA FROM FILE:
%velocities: maximum velocity in simulations for Couttee flow 1 x 4 double
%shearRates: corresponding shear rate = velocity/ymax 
%secretionRate: secretion rates for each simulation 1 x 9 double
%repRate: reproduction rates of groups stored in 9 x 4 double
    %repRate(i,j) = reproduction rate of group with secretion rate
    %secretionRate(i) and flow shear shearRates(j)
%repRateStd: standard deviation of reproduction rates in repRate

%scale = conversion from simulation units to time. 1.0 simulation units = 10^4 s

% group reproduction rate (no mutation)
figure;
ax = axes;
hold on;
for vi = 1:length(velocities)
        errorbar(sscl*secretionRate,scale*squeeze(repRate(:,vi)),...
            scale*squeeze(repRateStd(:,vi)),'-o','linewidth',3);
end
hold off;
axis([0 sscl*95 -0.2*scale 4*scale]);
xlabel('Group secretion rate (s^{-1})');
ylabel('Group reproduction rate (s^{-1})');
%lgd = legend('0','2.5 \times 10^{-4}','5.0 \times 10^{-4}','7.5 \times 10^{-4}','location','SouthEastOutside');
%title(lgd,'Shear rate (s^{-1})','FontSize',22);
%set(lgd,'FontSize',fsize,'linewidth',2); %,'color','none','Box','off');
set(gca,'fontsize',24);
box on;
set(ax,'linewidth',2);
print('group_reproduction_rates','-dpng');


%========================================================================
% (B) AVERAGE POPULATION SIZE PLOT
clear; clc;

load('population_secretion_data.mat');

% DATA FROM FILE:
%velocities: maximum velocity in simulations for Couttee flow 1 x 16 double
%shearRates: corresponding shear rate = velocity/ymax 
%population: 1 x 16 double giving average population over 80 runs with flow
    %shear of shearRates(i)
%popSTD: standard deviation of population values
%secretion: 1 x 16 double giving average secretion over 80 runs with flow
    %shear of shearRates(i)
%secSTD: standard devation of secretion rate values
%secretionRate: secretion rates for each simulation 1 x 9 double


shearrates = scale*shearRates;

figure;
ax = axes;
errorbar(shearrates,squeeze(population(1,:)),squeeze(popSTD(1,:)),'-o','linewidth',3);
axis([-0.1*scale 7.9*scale -200 11000])
xlabel('Shear rate (s^{-1})');
ylabel('Average population');
box on;
set(ax,'linewidth',2);
set(gca,'fontsize',24);
% save:
fig = gcf;
svfl = 'mutation_population';
%fig.PaperPositionMode = 'auto';
print(svfl,'-dpng','-r0');


%========================================================================
% (C) AVERAGE SECRETION RATE PLOT

figure;
ax = axes;
errorbar(shearrates,sscl*squeeze(secretion(1,:)),sscl*squeeze(secSTD(1,:)),'-o','linewidth',3);
axis([-0.1*scale 7.9*scale -2*sscl 60*sscl])
xlabel('Shear rate (s^{-1})');
ylabel('Average secretion rate (s^{-1})');
box on;
set(ax,'linewidth',2);
set(gca,'fontsize',24);
% save:
fig = gcf;
svfl = 'mutation_secretion';
%fig.PaperPositionMode = 'auto';
print(svfl,'-dpng','-r0');


