

% FIGURE 3 PLOTS (PHASE DIAGRAMS)

close all; clear; clc;
%=======================================================================
% (A) ANALYTICAL THEORY PLOT

load('theory_phase_data.mat');
% FILE DATA:
% d1 = 1 x 24 array of public good diffusion values
% d2 = 1 x 20 array of toxin diffusion values
% db = bacterial diffusion constant
% dr1 = d1 rescaled to db
% dr2 = d2 rescaled to db
% kvalue = 24 x 20 double corresponding to wavenumber giving fastest
    % growing eigenmode from analytical theory
% size = 24 x 20 array corresponding to group size = kvalue/2pi

figure;
pcolor(dr2,dr1,size);
shading flat;   
colorbar;
xlabel('Waste diffusion (d_2/d_b)');
ylabel('Public good diffusion (d_1/d_b)');
title('Analytical Theory');
set(gca,'fontsize',18);

%=======================================================================
% (B) PHASES FROM CONTINUOUS SIMULATION

clear; clc;
load('continuous_simulation_phase_data.mat');
% FILE DATA:
% gsize = group size as obtained from continuous simulations
% rightBoundary = d2/db values corresponding to stripe/spot phase boundary
% boundaryHeight = d1/db values corresponding to stripe/spot phase boundary

figure;
pcolor(dr2,dr1,gsize);
colorbar;
caxis([0 9]);
shading('flat');
hold on;
plot(rightBoundary,boundaryHeight,'black','linewidth',2);
hold off;
xlabel('Waste diffusion (d_2/d_b)');
ylabel('Public good diffusion (d_1/d_b)');
title('Continuous Simulations');
set(gca,'fontsize',18);

%=======================================================================
% (C) DISCRETE PHASE PLOT

clear; clc;
load('discrete_phase_data.mat');

figure;
pcolor(dr2,dr1,gsize);
caxis([0 9]);
shading flat;   
colorbar;
xlabel('Waste diffusion (d_2/d_b)');
ylabel('Public good diffusion (d_1/d_b)');
title('Discrete Simulations');
set(gca,'fontsize',18);


