        

function F = displayGraphics(xmin,xmax,Nx,ymin,ymax,Ny,bact,alive,...
            c1,c2,t,figHand,ogs1)

    dx = (xmax - xmin)/Nx;
    dy = (ymax - ymin)/Ny;
    x = xmin:dx:xmax; % including ghost nodes x(1) and x(Nx+3)
    y = ymin:dy:ymax; % including ghost nodes y(1) and y(Ny+3)
    
    invmaxs1 = 1.0/ogs1;
    
    if alive == 1 
        Nb = length(bact(bact(:,3)>=0)); % number alive 
        colors = zeros(Nb,3);
        xpos = bact(1:Nb,1);
        ypos = bact(1:Nb,2);
        for bi = 1:Nb
            colors(bi,:) =  [0.3 0.7*bact(bi,3)*invmaxs1 0.1]; 
            if bact(bi,3) <0
                disp('problem!...');
                disp(bact(bi,3));
            end
        end
    end
    
    mc1 = 1.0/(max(max(c1)) + 0.0001);
    mc2 = 1.0/(max(max(c2)) + 0.0001);
    chk = 10;
    
    Clrs = zeros(Ny+1,Nx+1,3);
    for xi = 2:Nx+2
        for yi = 2:Ny+2
            Clrs(yi-1,xi-1,:) = chk*1.5*[1.0*mc1 0.55*mc1 0]*c1(xi,yi) ...
                + chk*0.7*[0 0 1.0*mc2]*c2(xi,yi);
        end
    end        
    
    figure(figHand);
    image(x,y,Clrs);
    set(gca,'YDir','normal');
    shading interp;
    hold on;
    if alive ==1
        scatter(xpos,ypos,8,colors,'filled');
    end
    axis([xmin xmax ymin ymax]);

    title(sprintf('time = %1.8f',t)); 
    pause(0.0001);
    hold off;
    
    F = getframe(gcf);

end

