

% APPENDIX PLOTS (GROUP HISTOGRAMS)
close all; clear; clc;

%========================================================================
% (A) SHEAR RATE = 0.0 x 10^-4

% FILE DATA:
% secretionRates: array of secretion rates (x axis) from 0 to 100 by 0.1
% counts: number of microbes of a group with a given secretion rate


load('group_histogram_data_s0.0.mat');

shearRate = 0.0; 
figure;
ax = axes;
p1 = plot(sscl*secretionRates,counts,'linewidth',1.5); 
p1.Color(4) = alph;
axis([sscl*18 sscl*82 0 1.1*max(counts)]);
xlabel('Public good secretion rate (s^{-1})');
ylabel('Number of microbes');
tit = sprintf('Shear rate = %.1f x 10^{-4} (s^{-1})',shearRate);
title(tit);
box on;
set(gca,'fontsize',28);
set(ax,'linewidth',2);
figname = sprintf('srate_distribution_shear%.1f',shearRate);
print(figname,'-dpng');

%========================================================================
% (B) SHEAR RATE = 2.5 x 10^-4

clear; clc;

load('group_histogram_data_s2.5.mat');


shearRate = 2.5; 
figure;
ax = axes;
p1 = plot(sscl*secretionRates,counts,'linewidth',1.5); 
p1.Color(4) = alph;
axis([sscl*18 sscl*82 0 1.1*max(counts)]);
xlabel('Public good secretion rate (s^{-1})');
ylabel('Number of microbes');
tit = sprintf('Shear rate = %.1f x 10^{-4} (s^{-1})',shearRate);
title(tit);
box on;
set(gca,'fontsize',28);
set(ax,'linewidth',2);
figname = sprintf('srate_distribution_shear%.1f',shearRate);
print(figname,'-dpng');


%========================================================================
% (C) SHEAR RATE = 7.5 x 10^-4
clear; clc;

load('group_histogram_data_s7.5.mat');


shearRate = 7.5; 
figure;
ax = axes;
p1 = plot(sscl*secretionRates,counts,'linewidth',1.5); 
p1.Color(4) = alph;
axis([sscl*18 sscl*82 0 1.1*max(counts)]);
xlabel('Public good secretion rate (s^{-1})');
ylabel('Number of microbes');
tit = sprintf('Shear rate = %.1f x 10^{-4} (s^{-1})',shearRate);
title(tit);
box on;
set(gca,'fontsize',28);
set(ax,'linewidth',2);
figname = sprintf('srate_distribution_shear%.1f',shearRate);
print(figname,'-dpng');