


function [bvx, bvy] = brankine(rotation,radius,xp,yp)

dist = sqrt(xp.^2 + yp.^2);
theta = atan2(xp,yp);

factorInside = (rotation*dist)/(2*pi*(radius^2));
factorOutside = rotation./(2*pi*dist);


vfact = (dist<=radius).*factorInside + (dist>radius).*factorOutside;

bvy = sin(theta).*vfact;
bvx = -cos(theta).*vfact;
end


