

function  bact = constructBacteria(xmin,xmax,ymin,ymax,s1,initialNumBacteria,...
    initialNumGroups,aligngroups,maxBacteria)

% make bacteria into a matrix with columns: 
%[ xpos ypos s1 ] -- can add more...

btemp = zeros(maxBacteria,3);

if initialNumGroups > 0
    if aligngroups == 1
        grpPosY = 0.5*(ymax-ymin)*ones(initialNumGroups,1) + ymin;
        if initialNumGroups == 1
            grpPosX = 0.5*(xmax-xmin)+xmin; % center singleton group
        else
            tmpspacing = linspace(xmin,xmax,initialNumGroups+1);
            grpPosX = transpose(tmpspacing(1:initialNumGroups));
        end
    else
        grpPosX = (xmax-xmin)*rand(initialNumGroups,1) + xmin;
        grpPosY = (ymax-ymin)*rand(initialNumGroups,1) + ymin;
    end % if aligning groups

    grpPos = [grpPosX grpPosY];
end % create group positions if needed

btemp(:,3) = -100;
for bi = 1:initialNumBacteria
    if initialNumGroups > 0
        j = mod(bi,initialNumGroups) + 1;
        p1 = grpPos(j,1);
        p2 = grpPos(j,2);
    else
        p1 = (xmax-xmin)*rand + xmin;
        p2 = (ymax-ymin)*rand + ymin;
    end
    btemp(bi,1) = p1;       % initial x position
    btemp(bi,2) = p2;       % initial y position
    btemp(bi,3) = s1;       % initial s1 - public good secretion
end % for each bacteria

bact = btemp;
end


