

% FIGURE 4 PLOTS (BINARY MUTATION + SHEAR)
close all; clear; clc;

%=======================================================================
% (A) GROUP REPRODUCTION RATE VS SHEAR

load('group_reproduction_data.mat');

% FILE DATA:
% shearRates: 1 x 31 double corresponding to shear rates used in simulations
% gRate: 1 x 31 double of group reproduction rates averaged over 10 simulations
% gRateSTD: standard devation of group reproduction rates
% fitline: best fit line to group reproduction rates
% scale: unit conversion from simulation units to seconds

figure;
ax = axes;
errorbar(scale*shearRates,scale*gRate,scale*gRateSTD,'o','linewidth',3);
hold on;
plot(scale*shearRates,scale*fitline,'linewidth',3);
hold off;
axis(scale*[-0.25 shearRates(end)+0.5 -0.25 gRate(end)+gRateSTD(end)+0.1]);
xlabel('Shear rate (s^{-1})');
ylabel('Group reproduction rate (s^{-1})');
box on;
set(gca,'FontSize',24);
set(ax,'linewidth',2);
print('omplot.png','-dpng');

%=======================================================================
% (B) POPULATION PER GROUP VS SHEAR 
clear; clc;

load('group_population_data.mat');

% FILE DATA:
% velocities: maximum velocites of coutte flow simulations
% shearRates: corresponding shear rates = velocites/20
% gpop: 1 x 16 double containing group population vs shear averaged
    % averaged over 10 runs
% gpopSTD: standard deviation of group populations over 10 runs
% scale: to convert simulation units to time

% BEST FIT LINE:
[slope,slopeErr,interc] = bestfitline(shearRates,gpop);
fitline = slope*shearRates + interc;

figure;
ax = axes;
errorbar(scale*shearRates,gpop,gpopSTD,'o','linewidth',3);
hold on;
plot(scale*shearRates,fitline,'linewidth',3);
xlabel('Shear rate (s^{-1})');
ylabel('Population per group');
axis([-0.2*scale scale*8 90 170]);
box on;
set(gca,'FontSize',24);
set(ax,'linewidth',2);
print('num_per_grp','-dpng');


%=======================================================================
% (C) POPULATION VS SHEAR FOR VARIOUS MUTATION RATES WITH CRITICAL SHEAR 
clear; clc;

load('mutation_shear_data.mat');

% FILE DATA:
% shearRates: 1 x 16 array of shear rates used in simulations
% population: 16 x 3 double of population vs shear (16) for 3 mutation
    % rates: (6,8,11) x 10^-7 
% cshear1, cshear2, cshear3: crtical shear rates corresponding to each
    % mutation rate as obtained by equation in paper
% scale: conversion factor from simulation units to seconds

hgt = 9100; 
yshear = linspace(0,hgt,length(cshear1));
fsize = 24;

figure;
ax = axes;
hold on;
for mi = 1:size(population,2)
    h(mi) = errorbar(scale*shearRates,squeeze(population(:,mi)),squeeze(popSTD(:,mi)),'-o','linewidth',3);
end

cval1 = get(h(1),'color');
cval2 = get(h(2),'color');
cval3 = get(h(3),'color');

plot(cshear1,yshear,'--','color',cval1,'linewidth',3);
plot(cshear2,yshear,'--','color',cval2,'linewidth',3);
plot(cshear3,yshear,'--','color',cval3,'linewidth',3);

hold off;
axis([0 scale*7.6 0 9100]);
xlabel('Shear rate (s^{-1})','FontSize',fsize);
ylabel('Mean population','FontSize',fsize);
%set(gca,'FontSize',26);
ax.FontSize = fsize;
%{
lgd = legend('6 \times 10^{-7}','8 \times 10^{-7}','11 \times 10^{-7}',...
    'Location','SouthEastOutside');

title(lgd,'Mutation rates (s^{-1})','FontSize',22);
set(lgd,'FontSize',fsize,'linewidth',2); %,'color','none','Box','off');
%}
box on;
set(ax,'linewidth',2);

%print('mutation_shear_plot_legendOutside','-dpng');
print('mutation_shear_plot','-dpng');

