% find best fit line slope + error and intercept

function [xx,yy,zz] = bestfitline(tm,ngrps)

xbar = mean(tm);
ybar = mean(ngrps);

covar = 0;
ssx = 0;
for i = 1:length(ngrps)
    covar = covar + (tm(i) - xbar)*(ngrps(i)-ybar);
    ssx = ssx + (tm(i) - xbar)^2;
end

slope = covar/ssx;
intcp = ybar - slope*xbar;

yline = slope*tm + intcp;

err = ngrps - yline;
ssq = 0;
for j = 1:length(err)
    ssq = ssq + err(j)^2;
end
s = sqrt(ssq/(length(err)-2));

stdev = s/sqrt(ssx);

xx = slope;
yy = stdev;
zz = intcp;

end

