function create_figures_2C_and_2D

% precompute lookup table for mapping between kappa and J
kappa_map   = [linspace(0,10,250) linspace(10.001,5000,1000)];
J_map       = kappa_map.*besseli(1,kappa_map,1)./besseli(0,kappa_map,1);

% model parameters for simulations
lambda = .01;
power = 2;

% experimental parameters for simulations
N_vec = [1 2 4 8];
p_i_vec = sort(1./N_vec);

%-%-%-%-%-%-%-%-%-%-%-%-%
% Figure 2C, left panel %
%-%-%-%-%-%-%-%-%-%-%-%-%
Jbar_vec = linspace(.1,20,100);
for jj=1:numel(Jbar_vec)    
    % convert Jbar (resource) to kappa (concentration parameter of corresponding Von Mises noise distribution)
    kappa = interp1(J_map,kappa_map,Jbar_vec(jj),'linear','extrap');    
    % discretize Von Mises to numerically evaluate the intergral over epsilon
    [VM_x, VM_y] = discretize_VM(kappa);    
    % compute expected cost terms
    C_behavioral = abs(VM_x).^power;  % memory error loss
    Cbar_behavioral(jj) = mean(sum(bsxfun(@times,VM_y,C_behavioral),2)); % expected behavioral cost per item
    Cbar_neural(jj) = Jbar_vec(jj); % expected neural cost per item
end
cols = [1 0 0; 0 .8 0; 0 0 1; 1 0 1; 0 .5 1; 0 0 0; .5 .5 0; 0 .5 .5];
figure
set(gcf,'Position',get(gcf,'Position').*[0.1 0.1 .6 .6]);
set(gcf,'PaperPosition',get(gcf,'PaperPosition').*[0.1 0.1 .6 .6]);
hold on
for ii=1:numel(p_i_vec)
    plot(Jbar_vec,p_i_vec(ii).*Cbar_behavioral,'color',cols(ii,:));
end
plot(Jbar_vec,lambda*Cbar_neural(1,:),'k','linewidth',2);
ylim([0 0.25])
set(gca,'Ytick',[]);
xlabel('Jbar');
ylabel('Expected cost (a.u.)');
xlim([0 16]);
box off

%-%-%-%-%-%-%-%-%-%-%-%-%-%
% Figure 2C, cental panel %
%-%-%-%-%-%-%-%-%-%-%-%-%-%
figure
set(gcf,'Position',get(gcf,'Position').*[0.1 0.1 .6 .6]);
set(gcf,'PaperPosition',get(gcf,'PaperPosition').*[0.1 0.1 .6 .6]);
hold on
for ii=1:numel(p_i_vec)
    Cbar_total = p_i_vec(ii)*Cbar_behavioral + lambda*Cbar_neural; % expected total cost
    plot(Jbar_vec,Cbar_total,'color',cols(ii,:),'linewidth',1.5);
    plot(Jbar_vec,Cbar_total,'k--','linewidth',1);
    Jopt(ii) = Jbar_vec(Cbar_total==min(Cbar_total));
    plot([Jopt(ii) Jopt(ii)],[0 min(Cbar_total)],'k:','color',cols(ii,:));    
end
ylim([0 0.25])
set(gca,'Ytick',[]);
xlabel('Jbar');
ylabel('Expected cost (a.u.)');
xlim([0 16]);
box off

%-%-%-%-%-%-%-%-%-%-%-%-%-%
% Figure 2C, right panel  %
%-%-%-%-%-%-%-%-%-%-%-%-%-%
p_i_vec_finer = linspace(0,1,30);
for ii=1:numel(p_i_vec_finer)
    Cbar_total = p_i_vec_finer(ii)*Cbar_behavioral + lambda*Cbar_neural; % expected total cost
    Jopt_finer(ii) = Jbar_vec(Cbar_total==min(Cbar_total));
end
figure
set(gcf,'Position',get(gcf,'Position').*[0.1 0.1 .6 .6]);
set(gcf,'PaperPosition',get(gcf,'PaperPosition').*[0.1 0.1 .6 .6]);
hold on
plot(p_i_vec_finer,J_opt_finer,'k-');
for ii=1:numel(p_i_vec)
    plot(p_i_vec(ii),Jopt(ii),'ko','markerfacecolor',cols(ii,:))
end
set(gca,'TickDir','out','TickLength',get(gca,'TickLength')*2,'Ytick',0:3:12,'Xtick',0:.2:1)
ylim([0 12])
xlim([0 1]);
box off

%-%-%-%-%-%-%-%-%-%-%-%-%-%
% Figure 2D, right panel  %
%-%-%-%-%-%-%-%-%-%-%-%-%-%
figure
set(gcf,'Position',get(gcf,'Position').*[0.1 0.1 .6 .6]);
set(gcf,'PaperPosition',get(gcf,'PaperPosition').*[0.1 0.1 .6 .6]);
hold on
N_vec = 1./p_i_vec;
plot(N_vec,Jopt,'k-');
for ii=1:numel(N_vec)
    plot(N_vec(ii),Jopt(ii),'ko','markerfacecolor',cols(ii,:))
end
ylim([0 12])
xlim([.5 8.5]);
set(gca,'TickDir','out','TickLength',get(gca,'TickLength')*2,'Ytick',0:3:12,'Xtick',1:8)
box off
saveas(gcf,'illustration4.emf','emf')


% Discretize VM distributions into equally-spaced bins (1 distribution per element in kappa vector)
function [VM_x, VM_y] = discretize_VM(kappa,gvar)
VM_x = linspace(-pi,pi,101);
VM_x = VM_x(2:end)-diff(VM_x(1:2))/2;
VM_y = exp(bsxfun(@times,kappa',cos(VM_x)));
VM_y = bsxfun(@rdivide,VM_y,sum(VM_y,2));
