# -*- coding: utf-8 -*-
"""
Created on Tue Aug 22 07:56:05 2017

@author: mscholz
"""

# The code is divided into cells. Each cell can be run separately in Spyder by placing the cursor inside and pressing ctrl+Enter.
# After you run the code, you can display the source code of a function by placing the text cursor on it and pressing ctrl+G.
# The package alexma is only a kind of extension to fretbursts package.
# The documentation to fretbursts package can be found here:
#   http://nbviewer.jupyter.org/github/tritemio/FRETBursts_notebooks/blob/master/notebooks/FRETBursts%20-%20us-ALEX%20smFRET%20burst%20analysis.ipynb
#   http://fretbursts.readthedocs.io/en/latest/data_class.html

#%%

# The package (folder containing the modules) should be placed somewhere in the path.
# To show the searched locations type:
import sys
print(sys.path)
# To add a folder containing the package to the path, do the following:
sys.path.append(r'C:\Users\fessl\Google Drive\makrokomplex\projects\SecYEG\example data\alexma03')
# However, it adds the path only for the current session.

# For a more permanent solution, you can either go to Spyder --> Tools --> PYTHONPATH Manager,
# or add the above line to the startup file.
# You have to create the startup file in the startup folder, e.g. C:\Users\mscholz\.ipython\profile_default\startup\00-startup.py

# First we will import various packages (np,plt,fretbursts,glob,...):
import alexma03
from imports import *

# Now we import the alexma package: 
import alexma03 as am
# The functions within the module will be called e.g. as am.function_name(...). 

# Alternatively, alexma can be loaded using:
# from alexma import *
# This will make the modules imported in am directly available in this script.
# The function would be then called e.g. by function_name(...) instead of am.function_name(...)

# When a submodule is changed and you want to use its newer version in the same session, the submodule has to be reloaded, e.g.:
imp.reload(am)


#%%

datafolder = "data/"
# Before the data is loaded from .sm files, we have to sett various parameters used for loading.
# For that purpose we generate a Sett_hdf5 object which will be then passed to the load function.
sett = am.Sett_hdf5(donor=0, acceptor=1, alex_period=8000, alex_offset=10, alex_period_donor=(300,3300), alex_period_acceptor=(4400, 7300))
#We could also get some predefined settings by calling for example: sett = am.get_sett("NAR2014")     

# Now we can convert mulitple .sm files (matching the pattern in the glob2 sense) into hdf5 files 
am.convert_sm_multi(sett,pattern=datafolder+"*.sm",flag_plot_althist=True)
# If you want to use just a filename list, you can do the following:
#fnlist = ['data/data1.sm','data/data2.sm']
#[am.convert_sm(fn,sett) for fn in fnlist]

# You can convert and merge multiple .sm files matching the pattern patt into one hdf5 file.
# the function returns the name of the generated metged file
fname_merged = am.merge_sm_to_hdf_patt(sett, patt=datafolder+"*.sm")

# Instead of using match pattern, a list of filenames can be generated and passed to the merge function:
#fnlist = ['data1.sm','data2.sm']
#fnlist = ['data/'+f for f in fnlist]
#am.merge_sm_to_hdf(fnlist,sett)

#%%
# To load the spc PAX data generated by Becker&Hickl SPC630 board:
#fn_hdf = am.spc2hdf('data/ceb1-ctrl_PBSK-ctrl_01.hdf5')

#%%

# Now generate Analysis object, which will contain the results of various analyses of the data file.
# During initializaiton of the object, it loads the data in the hdf5 file, calculates background, performs corrections, burst search and basic burst selection.



filename_e = 'data/001secyeg only.hdf5'
a = am.Analysis(filename_e, leakage=0.05, dir_ex=0.01, gamma=0.8, busearch_F=5, fuse_ms=0, meas_type='ALEX')
# To load the PAX data from the .spc file you can use forexample  
# a = am.Analysis('../data/ceb1-ctrl_PBSK-ctrl_01.hdf5', leakage=0.1, dir_ex=0.0, gamma=1.0, busearch_F=5, fuse_ms=2, meas_type='PAX', settPAX=dict(D_ON = (400,1800), A_ON = (1900, 3300)))

# Attributes of the ALEXAnalysis object can be listed by typing "a.__dict__" (or "dir(a)")

# The fretburst Data object can be referenced as a.d, the Data after fusion as a.df, the Data after burst selection as a.ds, for example:
print(a.d.mburst[0].num_bursts)
print(a.df.mburst[0].num_bursts)
print(a.ds.mburst[0].num_bursts)
# As can be seen, the burst data are stored in the a.ds.mburst[0], which is Bursts object.
# The attributes of Bursts object can be found here:
# http://fretbursts.readthedocs.io/en/latest/burstsearch.html#module-fretbursts.phtools.burstsearch

#%%
# Useful values that can be accessed directly:
print('\nphoton times:')
print(a.d.ph_times_m[0])
print('\nanother way to get photon times of a certain photon stream:')
print(a.d.get_ph_times(ph_sel=Ph_sel(Dex='DAem'))) # or Ph_sel('all'), or Ph_sel(Dex='DAem', Aex='DAem') 
print('\noften you need to create a mask corresponding to photons in a certain photon stream')
print(a.d.get_ph_mask(ph_sel=Ph_sel(Aex='Aem')))
#documentation to Ph_sel object: http://fretbursts.readthedocs.io/en/latest/ph_sel.html

print('\nclock period:')
print(a.ds.clk_p)
print('\nA_em mask:')
print(a.ds.A_em[0])
print('\nD_ex mask:')
print(a.ds.D_ex[0])
#You can get a mask for photon selection by combining these: mask = a.d.D_ex[0]*a.d.A_em[0]
print('\nnumber of donor photons in individual bursts (corrected):')
print(a.ds.nd[0])
print('\nnumber of donor photons in individual bursts (corrected):')
print(a.ds.na[0])
print('\ntotal number of photons in individual bursts (corrected):')
print(a.ds.nt[0])
print('\nFRET in individual bursts:')
print(a.ds.E[0])
print('\nStoichiometry in individual bursts:')
print(a.ds.S[0])
print('\nTime of the last timestamp in seconds:')
print(a.ds.time_max)
print('\nNumber of bursts:')
print(a.ds.num_bursts[0])
print('\nBurst sizes:')
print(a.ds.burst_sizes_ich())
print('\nBurst widths in seconds:')
print(a.ds.burst_widths[0])

print('\nBursts object:')
print('Attributes of the Bursts object:')
print(dir(a.ds.mburst[0]))
print('\nSome of the burst properties:')
print('Bursts start times, widths (in clock periods), and counts:')
print(a.ds.mburst[0].start)
print(a.ds.mburst[0].width)
print(a.ds.mburst[0].counts)
print('\nCompact bursts info:')
am.bursts_info(a.ds)

# The values can be saved as a text file e.g. for further processing in Origin:
np.savetxt('E.txt', a.ds.E[0], fmt='%.3f', delimiter=' ', newline='\n', header='FRET values of bursts', footer='', comments='# ')
# Note that you do not have to specify all the keyword arguments, since thay have their default values, see the documentation of numpy.savetxt
# or if you want to combine more arrays of the same size into one file you can use:
am.savetxt_table('ES.txt', (a.ds.E[0],a.ds.S[0]), fmt='%.3f', delimiter='; ', newline='\n', header='E and S values of bursts', footer='', comments='# ')



# the description of various attributes of Data object: http://fretbursts.readthedocs.io/en/latest/data_class.html

#%%

# the bursts can be re-fused:
a.df = a.d.fuse_bursts(ms=5, mute=True) 
am.bursts_info(a.df)

# The default burst selection has already been done, but it can be done once again differently, either from fused bursts or from unfused ones, for example:
a.ds = a.df.select_bursts(select_bursts.E, E1=0.2, E2=0.8, computefret=False)
a.ds = a.ds.select_bursts(select_bursts.S, S1=0.2, S2=0.8, computefret=False)
am.bursts_info(a.ds)
a.ds = a.d.select_bursts(select_bursts.size, th1=35, th2=500, computefret=True)
am.bursts_info(a.ds)
#for more info see http://fretbursts.readthedocs.io/en/latest/burst_selection.html#burst-selection

#%%

# Close the so far generated figures:
plt.close('all')

# Run some predifined analysis procedures as defined in the proc method:
a.proc()
# This runs all the predefined analyses. To run only some of them, you have to specify the options keyword parameter.
# See the Analysis.proc() function code to see the available options
a.proc(options=('ES','scatter_fret_width','ACF'))

#The results of some of the analyses have been stored in the a.res dictionary
import pprint
pprint.pprint(a.res)

# This function has generated some figures and created some data. The attributes of the ALEXAnalysis object can be printed by
print(a.__dict__) # or print(vars(a)) 

# Of course, you can write your own function to process the data and you pass the Analysis object or the Data object as a parameter, e.g.
# def my_proc(a):
#   dplot(a.ds, hist_fret)
#   a.figs['whatever'] = plt.gcf()


#%%

# The analysis can be also run directly.
# Various attributes can be added to the object a.
# The generated figures which we want to preserve should be added to the a.figs dictionary by adding a new key, for example:

alex_jointplot(a.ds, kind='hex')
a.figs["ES"] = plt.gcf()
hist_list, bin_edges_list = am.plot_hist_width(a.ds,Ebins=(0,0.5,1.0))
a.figs["hist_width_Ebins"] = plt.gcf()

# Regular fitting of the histogram with three gaussians
fitpar = am.plot_Ehist_gaussfit(a.ds,numgauss=3)
print(fitpar)
# Customization of the fit model:
# see http://nbviewer.jupyter.org/github/tritemio/FRETBursts_notebooks/blob/master/notebooks/FRETBursts%20-%20us-ALEX%20smFRET%20burst%20analysis.ipynb
model = mfit.factory_two_gaussians(add_bridge=True)
model.print_param_hints()
model.set_param_hint('p1_center', value=0.3, min=-0.1, max=0.6)
fitpar = am.plot_Ehist_gaussfit(a.ds,model=model)
print(fitpar)
# or if you want to fit with an arbitrary function, you can use fit_Ehist function and pass the function name and starting p0 values as parameters.
# The examples of predefined fitfunctions are in the section _____FIT FUNCTIONS_____ 
fitpar,curve = am.fit_Ehist(a.ds,am.Fitfuns.gauss_two, [200,0.3,0.15,400,0.7,0.15], bins=20, flag_plot=True)
print(fitpar)
#and you can forexample store the fit values as an item in the a.res dictionary
a.res['fitpar'] = fitpar


#%%
# To calculate BVA you just have to create the BVA object:
a.bva = am.BVA(a.ds,n=5)
a.figs["BVA"] = plt.gcf()
# The BVA results are stored now in a.bva.res, which is a python dictionary
print(a.bva.res)

#Before RASP is run, we may check the p_same function:
a.psame = am.psame(a.ds,flag_plot=True)
a.figs["psame"] = plt.gcf()

#%%
# Also some basic CDE analysis has been implemented according to:
# http://nbviewer.jupyter.org/github/OpenSMFS/FRETBursts_notebooks/blob/master/notebooks/Example%20-%202CDE%20Method.ipynb
# This is considered to be in the testing stage, because for example the function calc_fret_2cde_gauss gives substantially different results than calc_fret_2cde.
# ALEX-2CDE can also be implemented by following the manual in the above mentioned jupyter notebook.
cde = CDE.cde(a, tau_s=50e-6)
print(cde['E'],cde['CDE']) 


#%%
# To run the RASP analysis, we first create the RASP object:
r = am.RASP(a.ds, dt_minmax_ms=(0,200))
r.plot2d_tseries(tseries=[10,30,100,200],cummul=True)
a.figs["RASPtser"] = plt.gcf()
# We can plot the histogram of E1 for a certain interval of E0 and time. The resulting histogram and bin_edges are returned by the function:
h,bin_edges = r.plothist(dt_limits_ms=(0,50), E0_limits=(0.6,1), bins=20, normed=False)
a.figs["RASPhist"] = plt.gcf()
# we can assign the RASP object to the Analysis object attribute: 
a.rasp = r
# The RASP pairs data can be accessed:
print(a.rasp.E0E1dt)
print(a.rasp.E0)

#%%

# The fretbursts package also defines many plot functions, which are called using a wrapper function dplot:
dplot(a.ds,scatter_width_size)
a.figs['whatever'] = plt.gcf()    
# see http://fretbursts.readthedocs.io/en/latest/plots.html
# or ...\Anaconda3\lib\site-packages\fretbursts\burst_plot.py


#%%

# Now we can close all the generated figures and show only the one of interest:
plt.close('all')
a.figs['ES'].show()
# or if inline IPython plotting applies, then just typing "a.figs["ESjoint"] will show the figure.

# You can access for example the RASP analysis data and manipulate them, e.g.
print(a.rasp.dt.mean())
# You can check which attributes the RASP() object has by typing a.rasp.__dict__

# The figures in a.figs can be combined to a png-report:
a.reportpng()
# This combined all the figures stored in the figure-dictionary a.figs and generated output file with automatic name "data_filename + _report.png"
# We can specifically choose some of the figures and set our own output filename:
a.reportpng(outname="testreport.png",figkeys=['alt','ES','BVA','RASPtser'])

# Single figures can be saved as png:
a.figs['BVA'].savefig('data/BVA.png')


#%%

# Data files can be batch-processed, for example this way:
fnlist = glob2.glob("data/0*.hdf5")
# subfolders would be accessed this way: fnlist = glob2.glob("data/**/*.hdf5")
for fn in fnlist:
    try:
        a = am.Analysis(fn, leakage=0.1, dir_ex=0.0, gamma=1.0)
        a.proc()
        a.reportpng()
    except:
        print('=============== Unable to process the file:' + fn + '=========================')
    plt.close('all')
    
    
# Instead of calling method a.proc() you can define your own function, e.g.
def proc1(a):
    alex_jointplot(a.ds, kind='hex')
    a.figs["ES"] = plt.gcf()
    a.bva = am.BVA(a.ds,n=5)
    a.figs["BVA"] = plt.gcf()
    
    
















 