# -*- coding: utf-8 -*-
"""
Created on Sun May 27 10:55:41 2018

@author: fessl
"""

import sys
print(sys.path)
# To add a folder containing the package to the path, do the following:
sys.path.append(r'C:\Users\fessl\Google Drive\makrokomplex\projects\SecYEG\example data\alexma03')
# However, it adds the path only for the current session.

# First we will import various packages (np,plt,fretbursts,glob,...):
import alexma03
from imports import *

# Now we import the alexma package: 
import alexma03 as am

datafolder = "data/"
# Before the data is loaded from .sm files, we have to sett various parameters used for loading.
# For that purpose we generate a Sett_hdf5 object which will be then passed to the load function.
sett = am.Sett_hdf5(donor=0, acceptor=1, alex_period=8000, alex_offset=10, alex_period_donor=(300,3300), alex_period_acceptor=(4400, 7300))
#We could also get some predefined settings by calling for example: sett = am.get_sett("NAR2014")     

filename_e = 'data/001secyeg only.hdf5'
#datafolder = "data/"
#am.convert_sm_multi(sett,pattern=datafolder+"*.sm",flag_plot_althist=True)
#am.convert_sm_multi(sett,filename_e,flag_plot_althist=True)
a = am.Analysis(filename_e, leakage=0.05, dir_ex=0.01, gamma=0.8, busearch_F=5, fuse_ms=0, meas_type='ALEX')

#a.ds = a.ds.select_bursts(select_bursts.S, S1=0.2, S2=0.8, computefret=True)
#a.ds = a.ds.select_bursts(select_bursts.ES, E1=-0.1,E2=1.1,S1=0.15, S2=0.75, rect=False, computefret=True)
a.ds = a.ds.select_bursts(select_bursts.size, th1=15, th2=500, computefret=False, add_naa=False)

plt.close('all')
alex_jointplot(a.ds, kind='kde')

a.ds = a.ds.select_bursts(select_bursts.ES, E1=-0.1,E2=1.1,S1=0.25, S2=0.75, rect=True, computefret=True)
alex_jointplot(a.ds, kind='hex')

a.proc()