#!/usr/local/bin/python

from Bio.SeqRecord import SeqRecord
from Bio.SeqIO.FastaIO import FastaWriter

def make_protein_record(nuc_record):
    """Returns a new SeqRecord with the translated sequence (default table)."""
    return SeqRecord(seq = nuc_record.seq.translate(to_stop=True), \
                     id = "trans_" + nuc_record.id, \
                     description = "translation of MiSeq read")

from Bio import SeqIO
proteins = (make_protein_record(nuc_rec) for nuc_rec in \
            SeqIO.parse("sample.trimmed.fastq", "fastq"))
writer = FastaWriter(open("sample.translate.fastq", "w"), wrap=0)
writer.write_file(proteins)

#SeqIO.write(proteins, "sample.translate.fastq", "fastq")
