
% This is a program built for analyzing the fly position extracted from mytracking
% This process an entire directory of user's choice
% and produce a single fly stat for further processing

function flyparadir()

  disp('Choose file source');
  myDir = uigetdir;
  disp ('Choose output directory');
  savedir = uigetdir;
  disp(savedir);
  myFiles = dir(fullfile(myDir,'*.mat'));
  getallfiles(myFiles,savedir);

end


function getallfiles(myFiles,savedir)%Get all the files in directory and loop through them
  %------------------------------------------------------------------------------------------------

for N = 1:length(myFiles);%Loop through every file in the directory

disp(myFiles(N).name);


wholepos =[];
tracks = struct('fname',[],'wholepos',[],'dis2center',[],'speed',[]);
tracks.center = [260 260];%Change the center of the dish here
tracks.radius = 260;% Change the radius of the plate here
disp(savedir)
tracks.savedir = savedir;%This is the directory of where the files will be saved
tracks.fname = myFiles(N).name;
load(myFiles(N).name);

%---------------All the subfunctions below--------------------------------
tracks.wholepos = wholepos;%Assign wholepos to tracks
tracks = redefinetrack(tracks);
tracks = correction(tracks);
displayresults(tracks);
exceloutput(tracks);
%--------------------subfunctions end here-------------------------------

%save tracks parameters
trackfname = strcat(tracks.fname,'tracks.mat');
save(fullfile(tracks.savedir,trackfname),'tracks');
close all;
end
end
%-------------------------------------------------------------------------------------------
function tracks = redefinetrack(tracks)

totalframe = length(tracks.wholepos)
  tracks.dis2center = zeros(totalframe);

  for i = 1 : totalframe

      tracks.dis2center(i) = sqrt(sum((tracks.wholepos(i,:)-tracks.center(1,:)).^2));

  end

end

% Correct error value
function tracks = correction(tracks)


%Identify two kinds of error: distance error and speed error

diserror = find(tracks.dis2center > tracks.radius); % Get the indices of the error position

tracks.wholepos(diserror,:) = [];

tracks.dis2center(:) = [];

for i = 1 : length(tracks.wholepos)

tracks.dis2center(i) = sqrt(sum((tracks.wholepos(i,:)-tracks.center(1,:)).^2));


  end

tracks.speed =[];

%recalculate speed using corrected data
for i = 2:length(tracks.wholepos)


    tracks.speed = [tracks.speed;sqrt(sum((tracks.wholepos(i,:)-tracks.wholepos((i-1),:)).^2))];


end

speederror = find(tracks.speed > 40);% Find speed error using new speed

tracks.speedavg = tracks.speed;
tracks.speedavg(speederror,:) = [];


fprintf('dis2center');
disp(length(tracks.dis2center));
fprintf('speed');
disp(length(tracks.speed));
fprintf('wholepos');
disp(length(tracks.wholepos));
end


% Plot all the results

function displayresults(tracks)

seconds = (length(tracks.wholepos)*4)/30;


figure;


title('Track results');

hold on
set(gca,'YDir','Reverse');

if length(tracks.wholepos) < 400

plot(tracks.wholepos(1:end,1),tracks.wholepos(1:end,2),'color',[0 0 1]);

end

if length(tracks.wholepos) > 400 && length(tracks.wholepos) < 800

plot(tracks.wholepos(1:400,1),tracks.wholepos(1:400,2),'color',[0 0 1]);
plot(tracks.wholepos(401:end,1),tracks.wholepos(401:end,2),'color',[0 0.5 1]);

end

if length(tracks.wholepos) > 800 && length(tracks.wholepos) < 1200

plot(tracks.wholepos(1:400,1),tracks.wholepos(1:400,2),'color',[0 0 1]);
plot(tracks.wholepos(401:800,1),tracks.wholepos(401:800,2),'color',[0 0.5 1]);
plot(tracks.wholepos(801:end,1),tracks.wholepos(801:end,2),'color',[0 1 1]);

end

if length(tracks.wholepos) > 1200 && length(tracks.wholepos) < 1600

plot(tracks.wholepos(1:400,1),tracks.wholepos(1:400,2),'color',[0 0 1]);
plot(tracks.wholepos(401:800,1),tracks.wholepos(401:800,2),'color',[0 0.5 1]);
plot(tracks.wholepos(801:1200,1),tracks.wholepos(801:1200,2),'color',[0 1 1]);
plot(tracks.wholepos(1201:end,1),tracks.wholepos(1201:end,2),'color',[0 1 0.5]);

end

if length(tracks.wholepos) > 1600 && length(tracks.wholepos) < 2000
    plot(tracks.wholepos(1:400,1),tracks.wholepos(1:400,2),'color',[0 0 1]);
    plot(tracks.wholepos(401:800,1),tracks.wholepos(401:800,2),'color',[0 0.5 1]);
    plot(tracks.wholepos(801:1200,1),tracks.wholepos(801:1200,2),'color',[0 1 1]);
    plot(tracks.wholepos(1201:1600,1),tracks.wholepos(1201:1600,2),'color',[0 1 0.5]);
    plot(tracks.wholepos(1601:end,1),tracks.wholepos(1601:end,2),'color',[0 1 0.5]);

end


if length(tracks.wholepos) > 2000 && length(tracks.wholepos) < 2400

    plot(tracks.wholepos(1:400,1),tracks.wholepos(1:400,2),'color',[0 0 1]);
    plot(tracks.wholepos(401:800,1),tracks.wholepos(401:800,2),'color',[0 0.5 1]);
    plot(tracks.wholepos(801:1200,1),tracks.wholepos(801:1200,2),'color',[0 1 1]);
    plot(tracks.wholepos(1201:1600,1),tracks.wholepos(1201:1600,2),'color',[0 1 0.5]);
    plot(tracks.wholepos(1601:2000,1),tracks.wholepos(1601:2000,2),'color',[0 1 0.5]);
    plot(tracks.wholepos(2001:end,1),tracks.wholepos(2001:end,2),'color',[0.5 1 0]);

end

if length(tracks.wholepos) > 2400 && length(tracks.wholepos) < 2800
    plot(tracks.wholepos(1:400,1),tracks.wholepos(1:400,2),'color',[0 0 1]);
    plot(tracks.wholepos(401:800,1),tracks.wholepos(401:800,2),'color',[0 0.5 1]);
    plot(tracks.wholepos(801:1200,1),tracks.wholepos(801:1200,2),'color',[0 1 1]);
    plot(tracks.wholepos(1201:1600,1),tracks.wholepos(1201:1600,2),'color',[0 1 0.5]);
    plot(tracks.wholepos(1601:2000,1),tracks.wholepos(1601:2000,2),'color',[0 1 0.5]);
    plot(tracks.wholepos(2001:2400,1),tracks.wholepos(2001:2400,2),'color',[0.5 1 0]);
    plot(tracks.wholepos(2401:end,1),tracks.wholepos(2401:end,2),'color',[1 1 0]);

end

if length(tracks.wholepos) > 2800 && length(tracks.wholepos) < 3200
     plot(tracks.wholepos(1:400,1),tracks.wholepos(1:400,2),'color',[0 0 1]);
    plot(tracks.wholepos(401:800,1),tracks.wholepos(401:800,2),'color',[0 0.5 1]);
    plot(tracks.wholepos(801:1200,1),tracks.wholepos(801:1200,2),'color',[0 1 1]);
    plot(tracks.wholepos(1201:1600,1),tracks.wholepos(1201:1600,2),'color',[0 1 0.5]);
    plot(tracks.wholepos(1601:2000,1),tracks.wholepos(1601:2000,2),'color',[0 1 0.5]);
    plot(tracks.wholepos(2001:2400,1),tracks.wholepos(2001:2400,2),'color',[0.5 1 0]);
    plot(tracks.wholepos(2401:2800,1),tracks.wholepos(2401:2800,2),'color',[1 1 0]);
    plot(tracks.wholepos(2801:end,1),tracks.wholepos(2801:end,2),'color',[1 0.5 0]);

end

if length(tracks.wholepos) > 3200
    plot(tracks.wholepos(1:400,1),tracks.wholepos(1:400,2),'color',[0 0 1]);
    plot(tracks.wholepos(401:800,1),tracks.wholepos(401:800,2),'color',[0 0.5 1]);
    plot(tracks.wholepos(801:1200,1),tracks.wholepos(801:1200,2),'color',[0 1 1]);
    plot(tracks.wholepos(1201:1600,1),tracks.wholepos(1201:1600,2),'color',[0 1 0.5]);
    plot(tracks.wholepos(1601:2000,1),tracks.wholepos(1601:2000,2),'color',[0 1 0.5]);
    plot(tracks.wholepos(2001:2400,1),tracks.wholepos(2001:2400,2),'color',[0.5 1 0]);
    plot(tracks.wholepos(2401:2800,1),tracks.wholepos(2401:2800,2),'color',[1 1 0]);
    plot(tracks.wholepos(2801:3200,1),tracks.wholepos(2801:3200,2),'color',[1 0.5 0]);
    plot(tracks.wholepos(3201:end,1),tracks.wholepos(3201:end,2),'color',[1 0 0]);

end


plot(tracks.center(1,:),tracks.center(:,1),'or');%This plots a circle at the center of the dish


theta = linspace(0,2*pi);%Plot the dish on the tracking results

xc = double(tracks.center(1,1));
yc = double(tracks.center(1,2));


x = tracks.radius*cos(theta) + xc;
y = tracks.radius*sin(theta) + yc;

plot(x,y,'k','LineWidth',3);


filename = 'Tracks_results.fig';
fig1 = strcat(tracks.fname,filename);% Saves the figure as file name + track results
hold off

figure;

tracks.avgspeed = sum(tracks.speed(:))/length(tracks.speed);
str2 = num2str(tracks.avgspeed);
str1 = 'Average speed: ';
str = strcat(str1,str2);
dim = [.15 .4 .7 .325];


plot(smooth(tracks.speed));

title(str);
     
end

function exceloutput(tracks)%This ouputs parameters as excel files


outputpos = tracks.wholepos;
outputspeed = tracks.speed;
outputdis2center = tracks.dis2center;
xlsname2 = strcat(tracks.fname,'speed','excel.xls');% filename for the speed excel spreadsheet
xlswrite(xlsname2,outputspeed);

end
