

## change the path to "vennpie.R" appropriately
source("./vennpie.R");
source("./vennmosaic.R");


Set <- vector("list",3);
Set[[1]] <- seq(1,10,by=1);  # set 1, 10 elements
Set[[2]] <- seq(5,15,by=1);  # set 2, 11 elements
Set[[3]] <- seq(6,28,by=2);  # set 3, 12 elements

n <- length(Set);

A <- matrix(0,n,n);
B <- matrix(0,n,n);
AB<- matrix(0,n,n);

for( i in 1:n ){
  for( j in i:n ){
    A[i,j] <- length(Set[[i]]);     # size of Set i
    B[i,j] <- length(Set[[j]]);     # size of Set j
    AB[i,j]<- length( intersect(Set[[i]],Set[[j]]) );   # overlap size between Set i and Set j
  }
}

vennpie( A,B,AB, main="venn-pie", labels.diag=c("Set1","Set2","Set3"), show.overlap.size=TRUE, cex.overlap.size=1.2 );

vennmosaic( A,B,AB, main="venn-mosaic", labels.diag=c("Set1","Set2","Set3"), show.overlap.size=TRUE, cex.overlap.size=0.8 );

