##########
#
# This R source code is a supplementary code file to the manuscript:
#
# Assessing Reliability in Neuroimaging Research Through Intra-Class Effect Decomposition (ICED)
# (submitted to eLife)
# Andreas M. Brandmaier, Elisabeth Wenger, Nils C. Bodammer, Simone Kühn, Naftali Raz, and Ulman Lindenberger
#
# The analyzed data are freely available via the Open Science Framework: https://osf.io/t68my/
#
# Script author: Andreas M. Brandmaier <brandmaier@mpib-berlin.mpg.de>
# Date: June 13, 2018
#
##########

# (0) set some basic properties

likelihood = "Wishart"
#likelihood = "Normal"

# (1) read data
dat <- read.csv("mwf_alic.csv",sep=",",dec=".")
names(dat) <- c("T1","T2","T3")

# (2) model specification

# (2a) unconstrained model

#
# This model specification was automatically generated by Onyx
#
library(lavaan);
model<-"
! regressions 
T=~1.0*T1
T=~1.0*T2
T=~1.0*T3
P1=~1.0*T1
P1=~1.0*T2
P2=~1.0*T3
E1=~1.0*T1
E2=~1.0*T2
E3=~1.0*T3
! residuals, variances and covariances
T ~~ t*T
P1 ~~ p*P1
P2 ~~ p*P2
E1 ~~ e*E1
E2 ~~ e*E2
E3 ~~ e*E3
T ~~ 0.0*P1
T ~~ 0.0*P2
T ~~ 0.0*E1
T ~~ 0.0*E2
T ~~ 0.0*E3
P1 ~~ 0.0*P2
P1 ~~ 0.0*E1
P1 ~~ 0.0*E2
P1 ~~ 0.0*E3
P2 ~~ 0.0*E1
P2 ~~ 0.0*E2
P2 ~~ 0.0*E3
E1 ~~ 0.0*E2
E1 ~~ 0.0*E3
E2 ~~ 0.0*E3
! observed means
T1~1;
T2~1;
T3~1;
";

# (2b) model with session error variance set equal to residual error variance

model_pe<-"
! regressions 
T=~1.0*T1
T=~1.0*T2
T=~1.0*T3
P1=~1.0*T1
P1=~1.0*T2
P2=~1.0*T3
E1=~1.0*T1
E2=~1.0*T2
E3=~1.0*T3
! residuals, variances and covariances
T ~~ t*T
P1 ~~ p*P1
P2 ~~ p*P2
E1 ~~ e*E1
E2 ~~ e*E2
E3 ~~ e*E3
T ~~ 0.0*P1
T ~~ 0.0*P2
T ~~ 0.0*E1
T ~~ 0.0*E2
T ~~ 0.0*E3
P1 ~~ 0.0*P2
P1 ~~ 0.0*E1
P1 ~~ 0.0*E2
P1 ~~ 0.0*E3
P2 ~~ 0.0*E1
P2 ~~ 0.0*E2
P2 ~~ 0.0*E3
E1 ~~ 0.0*E2
E1 ~~ 0.0*E3
E2 ~~ 0.0*E3
! observed means
T1~1;
T2~1;
T3~1;
p==e
";
result_pe<-lavaan(model_pe, data=dat, fixed.x=FALSE, missing="FIML",likelihood=likelihood);

# (2c) constrained model with session error variance set to zero

model_p0<-"
! regressions 
T=~1.0*T1
T=~1.0*T2
T=~1.0*T3
P1=~1.0*T1
P1=~1.0*T2
P2=~1.0*T3
E1=~1.0*T1
E2=~1.0*T2
E3=~1.0*T3
! residuals, variances and covariances
T ~~ t*T
P1 ~~ p*P1
P2 ~~ p*P2
E1 ~~ e*E1
E2 ~~ e*E2
E3 ~~ e*E3
T ~~ 0.0*P1
T ~~ 0.0*P2
T ~~ 0.0*E1
T ~~ 0.0*E2
T ~~ 0.0*E3
P1 ~~ 0.0*P2
P1 ~~ 0.0*E1
P1 ~~ 0.0*E2
P1 ~~ 0.0*E3
P2 ~~ 0.0*E1
P2 ~~ 0.0*E2
P2 ~~ 0.0*E3
E1 ~~ 0.0*E2
E1 ~~ 0.0*E3
E2 ~~ 0.0*E3
! observed means
T1~1;
T2~1;
T3~1;
p==0
";
result_p0<-lavaan(model_p0, data=dat, fixed.x=FALSE, missing="FIML",likelihood=likelihood);


# (2d) constrained model with true score variance set to zero

model_t0<-"
! regressions 
T=~1.0*T1
T=~1.0*T2
T=~1.0*T3
P1=~1.0*T1
P1=~1.0*T2
P2=~1.0*T3
E1=~1.0*T1
E2=~1.0*T2
E3=~1.0*T3
! residuals, variances and covariances
T ~~ t*T
P1 ~~ p*P1
P2 ~~ p*P2
E1 ~~ e*E1
E2 ~~ e*E2
E3 ~~ e*E3
T ~~ 0.0*P1
T ~~ 0.0*P2
T ~~ 0.0*E1
T ~~ 0.0*E2
T ~~ 0.0*E3
P1 ~~ 0.0*P2
P1 ~~ 0.0*E1
P1 ~~ 0.0*E2
P1 ~~ 0.0*E3
P2 ~~ 0.0*E1
P2 ~~ 0.0*E2
P2 ~~ 0.0*E3
E1 ~~ 0.0*E2
E1 ~~ 0.0*E3
E2 ~~ 0.0*E3
! observed means
T1~1;
T2~1;
T3~1;
t==0
";
result_t0<-lavaan(model_t0, data=dat, fixed.x=FALSE, missing="FIML",likelihood=likelihood);


result<-lavaan(model, data=dat, fixed.x=FALSE, missing="FIML",likelihood=likelihood);
summary(result, fit.measures=TRUE);

# (3) Inspect results

pid <- which(parTable(result)$label=="p")[1]
eid <- which(parTable(result)$label=="e")[1]
tid <- which(parTable(result)$label=="t")[1]
pest <- parTable(result)$est[pid]
eest <- parTable(result)$est[eid]
test <- parTable(result)$est[tid]

# values obtained from Onyx for sanity check
onyx.test = 6.97284
onyx.pest = 0.58613
onyx.eest = 0.52397


cat("Session variance ",round(pest,2),"; ",pest, "\n") 
cat("Residual error variance ",round(eest,2),"; ",eest,"\n")
cat("True score variance ",round(test,2),"; ",test,"\n")

# reliability estimates
cat("ICC ",test/(pest+eest+test),"\n")

cat("ICC (back-to-back) ",(test+pest)/(test+pest+eest),"\n")

cat ("ICC2 ",test/(test+( (eest+pest)*(eest+2*pest) )/(3*eest+4*pest)),"\n")

# chi^2 tests as reported in the manuscript

cat("LR test for session variance is zero\n")
anova(result_p0,result)
cat("LR test for true score variance is zero\n")
anova(result_t0,result)
cat("Wald test (residual error is zero) ","\n")
lavTestWald(result,"e==0")

cat("LR test for session variance equals residual error variance\n")
anova(result,result_pe)