## STATISTICAL ANALYSIS OF PEAK COHERENCE AND FREQUENCY

# Reading data from Excel file
Data1<-read_excel("PATHWAY_TO_FILE/Datasets.xlsx", sheet = "Dataset1", col_names = TRUE, col_types = NULL, 
                  na = "",skip = 0)
Data2<-read_excel("PATHWAY_TO_FILE/Datasets.xlsx", sheet = "Dataset2", col_names = TRUE, col_types = NULL, 
                  na = "",skip = 0)
Data3<-read_excel("PATHWAY_TO_FILE/Datasets.xlsx", sheet = "Dataset3", col_names = TRUE, col_types = NULL, 
                  na = "",skip = 0)

# Step 1: Performing MANOVA, multivariate ANOVA
coh.manova1<-manova(cbind(Coherence,Frequency) ~ as.factor(Phase),data=Data1)
summary(coh.manova1, test = "Hotelling-Lawley")

# Step2: If significant, perform a multivariate post-hoc test between two conditions
library("Hotelling", lib.loc="~/R/win-library/3.3") # load Hotelling Package
HotT2 = hotelling.test(Coherence+Frequency~Phase, data = Data2)
HotT2

# Step 3: If significant, perform a univariate post-hoc test to isolate each variable
# Peak coherence
with(Data3, (t.test(Coherence_QS, Coherence_TR, alternative='two.sided', conf.level=.95, paired=TRUE)))
with(Data3, (t.test(Coherence_QS, Coherence_S1, alternative='two.sided', conf.level=.95, paired=TRUE)))
with(Data3, (t.test(Coherence_TR, Coherence_S1, alternative='two.sided', conf.level=.95, paired=TRUE)))
# Frequency
with(Data3, (t.test(Frequency_QS, Frequency_TR, alternative='two.sided', conf.level=.95, paired=TRUE)))
with(Data3, (t.test(Frequency_QS, Frequency_S1, alternative='two.sided', conf.level=.95, paired=TRUE)))
with(Data3, (t.test(Frequency_TR, Frequency_S1, alternative='two.sided', conf.level=.95, paired=TRUE)))